/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis.locals;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.analysis.params.EnhancedParamsDiff;
import org.sinytra.adapter.patch.analysis.params.LayeredParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.params.ParamsDiffSnapshot;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.transformer.operation.param.TransformParameters;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public final class LocalVarAnalyzer {
    @Nullable
    public static CapturedLocalsInfo getCapturedLocals(MethodContext methodContext) {
        AdapterUtil.CapturedLocals capturedLocals = AdapterUtil.getCapturedLocals(methodContext.getMixinMethod(), methodContext);
        if (capturedLocals == null) {
            return null;
        }
        List<MethodContext.LocalVariable> available = methodContext.getTargetMethodLocals(capturedLocals.target());
        if (available == null) {
            return null;
        }
        List<Type> availableTypes = available.stream().map(MethodContext.LocalVariable::type).toList();
        LayeredParamsDiffSnapshot diff = EnhancedParamsDiff.createLayered(capturedLocals.expected(), availableTypes);
        return new CapturedLocalsInfo(capturedLocals, diff, availableTypes);
    }

    public static InsnList findInitializerInsns(MethodNode methodNode, int index) {
        InsnList insns = new InsnList();
        block0: for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (varInsn.var != index || !OpcodeUtil.isStoreOpcode(varInsn.getOpcode())) continue;
            for (AbstractInsnNode prev = insn.getPrevious(); prev != null; prev = prev.getPrevious()) {
                if (prev instanceof LabelNode) break block0;
                if (prev instanceof FrameNode || prev instanceof LineNumberNode) continue;
                insns.insert(prev.clone(Map.of()));
            }
        }
        return insns;
    }

    public static CapturedLocalsTransform analyzeCapturedLocals(AdapterUtil.CapturedLocals capturedLocals, MethodNode methodNode) {
        int paramLocalStart = capturedLocals.paramLocalStart();
        LocalVariableLookup table = capturedLocals.lvt();
        ArrayList<Integer> used = new ArrayList<Integer>();
        ArrayList<LocalVariableNode> usedLocalNodes = new ArrayList<LocalVariableNode>();
        for (AbstractInsnNode insn : methodNode.instructions) {
            int ordinal;
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            LocalVariableNode node = table.getByIndexOrNull(varInsn.var);
            if (node == null || (ordinal = table.getOrdinal(node)) < paramLocalStart || ordinal > capturedLocals.paramLocalEnd()) continue;
            used.add(ordinal - 1);
            usedLocalNodes.add(node);
        }
        TransformParameters remover = TransformParameters.builder().chain(b -> IntStream.range(paramLocalStart, capturedLocals.paramLocalEnd()).filter(i -> !used.contains(i)).boxed().sorted(Collections.reverseOrder()).forEach(b::remove)).build();
        return new CapturedLocalsTransform(used, remover, usedLocalNodes);
    }

    public static void findVariableInitializerInsns(MethodNode methodNode, boolean isStatic, int index, Int2ObjectMap<InsnList> varInsnLists, Int2IntMap usageCount) {
        InsnList insns = new InsnList();
        block0: for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (varInsn.var != index || !OpcodeUtil.isStoreOpcode(varInsn.getOpcode())) continue;
            for (AbstractInsnNode prev = insn.getPrevious(); prev != null; prev = prev.getPrevious()) {
                if (prev instanceof LabelNode) break block0;
                if (prev instanceof FrameNode || prev instanceof LineNumberNode) continue;
                if (prev instanceof VarInsnNode) {
                    VarInsnNode vInsn = (VarInsnNode)prev;
                    if ((isStatic || vInsn.var != 0) && OpcodeUtil.isLoadOpcode(vInsn.getOpcode())) {
                        if (!varInsnLists.containsKey(vInsn.var)) {
                            LocalVarAnalyzer.findVariableInitializerInsns(methodNode, isStatic, vInsn.var, varInsnLists, usageCount);
                        }
                        usageCount.compute(vInsn.var, (key, existing) -> existing == null ? 1 : existing + 1);
                    }
                }
                insns.insert(prev.clone(Map.of()));
            }
        }
        varInsnLists.put(index, (Object)insns);
    }

    private LocalVarAnalyzer() {
    }

    public record CapturedLocalsInfo(AdapterUtil.CapturedLocals capturedLocals, ParamsDiffSnapshot diff, List<Type> availableTypes) {
    }

    public record CapturedLocalsTransform(List<Integer> used, MethodTransform remover, List<LocalVariableNode> usedLocalNodes) {
        public CapturedLocalsUsage getUsage(AdapterUtil.CapturedLocals capturedLocals) {
            LocalVariableLookup targetTable = new LocalVariableLookup(capturedLocals.target().methodNode());
            Int2ObjectOpenHashMap varInsnLists = new Int2ObjectOpenHashMap();
            Int2IntOpenHashMap usageCount = new Int2IntOpenHashMap();
            this.used.forEach(arg_0 -> CapturedLocalsTransform.lambda$getUsage$0(targetTable, capturedLocals, (Int2ObjectMap)varInsnLists, (Int2IntMap)usageCount, arg_0));
            return new CapturedLocalsUsage(targetTable, (Int2IntMap)usageCount, (Int2ObjectMap<InsnList>)varInsnLists);
        }

        private static /* synthetic */ void lambda$getUsage$0(LocalVariableLookup targetTable, AdapterUtil.CapturedLocals capturedLocals, Int2ObjectMap varInsnLists, Int2IntMap usageCount, Integer ordinal) {
            int index = targetTable.getByOrdinal((int)ordinal.intValue()).index;
            LocalVarAnalyzer.findVariableInitializerInsns(capturedLocals.target().methodNode(), capturedLocals.isStatic(), index, (Int2ObjectMap<InsnList>)varInsnLists, usageCount);
        }
    }

    public record CapturedLocalsUsage(LocalVariableLookup targetTable, Int2IntMap usageCount, Int2ObjectMap<InsnList> varInsnLists) {
    }
}

