/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.sinytra.adapter.patch.util.MethodQualifier;

public record LVTOffsets(Map<String, Map<MethodQualifier, List<Swap>>> reorders) {
    public static final Codec<LVTOffsets> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.unboundedMap(MethodQualifier.CODEC, (Codec)Swap.CODEC.listOf())).fieldOf("reorders").forGetter(LVTOffsets::reorders)).apply((Applicative)instance, LVTOffsets::new));

    public OptionalInt findReorder(String cls, String methodName, String methodDesc, int index) {
        MethodQualifier qualifier;
        List<Swap> methodReorders;
        Map<MethodQualifier, List<Swap>> map = this.reorders.get(cls);
        if (map != null && (methodReorders = map.get(qualifier = new MethodQualifier(methodName, methodDesc))) != null) {
            for (Swap swap : methodReorders) {
                if (swap.original() != index) continue;
                return OptionalInt.of(swap.modified());
            }
        }
        return OptionalInt.empty();
    }

    public static LVTOffsets fromJson(JsonElement json) {
        return (LVTOffsets)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(s -> {
            throw new RuntimeException("Error deserializing lvt offsets: " + s);
        })).getFirst();
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(s -> {
            throw new RuntimeException("Error serializing lvt offsets: " + s);
        });
    }

    public record Swap(int original, int modified) {
        public static final Codec<Swap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("original").forGetter(Swap::original), (App)Codec.INT.fieldOf("modified").forGetter(Swap::modified)).apply((Applicative)instance, Swap::new));
    }
}

