/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ChromaticSheetItem
extends Item {
    public ChromaticSheetItem(Item.Properties properties) {
        super(properties);
    }

    public List<Frame> getLayers(ItemStack stack) {
        return (List)stack.getOrDefault(Exposure.DataComponents.CHROMATIC_SHEET_LAYERS, Collections.emptyList());
    }

    public void addLayer(ItemStack stack, Frame frame) {
        ArrayList<Frame> layers = new ArrayList<Frame>(this.getLayers(stack));
        Preconditions.checkState((layers.size() < 3 ? 1 : 0) != 0, (Object)"Cannot add layer. Chromatic Sheet already has 3 layers.");
        layers.add(frame);
        stack.set(Exposure.DataComponents.CHROMATIC_SHEET_LAYERS, layers);
    }

    public boolean canCombine(ItemStack stack) {
        return this.getLayers(stack).size() >= 3;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        List<Frame> layers = this.getLayers(stack);
        if (!layers.isEmpty()) {
            MutableComponent component = Component.translatable((String)"gui.exposure.channel.red").withStyle(Style.EMPTY.withColor(ColorChannel.RED.getRepresentationColor()));
            if (layers.size() >= 2) {
                component.append((Component)Component.translatable((String)"gui.exposure.channel.separator").withStyle(ChatFormatting.GRAY));
                component.append((Component)Component.translatable((String)"gui.exposure.channel.green").withStyle(Style.EMPTY.withColor(ColorChannel.GREEN.getRepresentationColor())));
            }
            if (layers.size() >= 3) {
                component.append((Component)Component.translatable((String)"gui.exposure.channel.separator").withStyle(ChatFormatting.GRAY));
                component.append((Component)Component.translatable((String)"gui.exposure.channel.blue").withStyle(Style.EMPTY.withColor(ColorChannel.BLUE.getRepresentationColor())));
            }
            tooltipComponents.add((Component)component);
            if (layers.size() >= 3) {
                tooltipComponents.add((Component)Component.translatable((String)"item.exposure.chromatic_sheet.use_tooltip").withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"item.exposure.chromatic_sheet.info").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.canCombine(stack)) {
                boolean printed = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("printed");
                ItemStack finalizedItem = this.combineIntoPhotograph(player, stack, printed);
                player.getInventory().setItem(slotId, finalizedItem);
            }
        }
    }

    public ItemStack combineIntoPhotograph(@NotNull ServerPlayer player, ItemStack stack, boolean printed) {
        Preconditions.checkState((boolean)this.canCombine(stack), (Object)("Combining Chromatic Sheet requires 3 layers. " + String.valueOf(stack)));
        String exposureId = ExposureIdentifier.createId((Entity)player, "chromatic");
        List<Frame> layers = this.getLayers(stack);
        List<ExposureIdentifier> layersIdentifiers = layers.stream().map(Frame::identifier).toList();
        ItemStack photographStack = this.createPhotographStack(ExposureIdentifier.id(exposureId), layers);
        ExposureServer.exposureRepository().expect(player, exposureId, (pl, id) -> ExposureServer.exposureRepository().update((String)id, exposure -> exposure.withTag((Function<ExposureData.Tag, ExposureData.Tag>)((Function)tag -> tag.withWasPrintedSetTo(printed)))));
        Packets.sendToClient(new CreateChromaticExposureS2CP(exposureId, layersIdentifiers), player);
        return photographStack;
    }

    protected ItemStack createPhotographStack(ExposureIdentifier identifier, List<Frame> layers) {
        Frame frameData = Frame.intersect(identifier, layers);
        frameData = frameData.toMutable().setType(ExposureType.COLOR).setChromatic(true).toImmutable();
        ItemStack photographStack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
        photographStack.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frameData);
        photographStack.set(Exposure.DataComponents.PHOTOGRAPH_TYPE, (Object)ExposureType.COLOR);
        return photographStack;
    }
}

