/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.entity;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandSetRotationsS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.CameraStandStopControllingS2CP;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.entity.CameraStandRedstoneControl;
import io.github.mortuusars.exposure.world.inventory.CameraOnStandAttachmentsMenu;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.sound.Sound;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraStandEntity
extends Entity
implements CameraHolder {
    protected static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<ItemStack> DATA_ID_CAMERA = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final EntityDataAccessor<Integer> DATA_ID_COOLDOWN_TIME = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_COOLDOWN = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_OPERATOR_ID = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> DATA_ID_MALFUNCTIONED = SynchedEntityData.defineId(CameraStandEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final Predicate<Entity> RIDABLE_MINECARTS = entity -> entity instanceof AbstractMinecart && ((AbstractMinecart)entity).getMinecartType() == AbstractMinecart.Type.RIDEABLE;
    protected CameraStandRedstoneControl redstoneControl = new CameraStandRedstoneControl(this);
    protected UUID ownerPlayerId = Util.NIL_UUID;

    public CameraStandEntity(EntityType<? extends CameraStandEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_HURT, (Object)0);
        builder.define(DATA_ID_HURTDIR, (Object)1);
        builder.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(DATA_ID_CAMERA, (Object)ItemStack.EMPTY);
        builder.define(DATA_ID_OPERATOR_ID, (Object)-1);
        builder.define(DATA_ID_COOLDOWN_TIME, (Object)0);
        builder.define(DATA_ID_COOLDOWN, (Object)0);
        builder.define(DATA_ID_MALFUNCTIONED, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        ItemStack camera;
        if (dataAccessor.equals(DATA_ID_CAMERA) && !(camera = this.getCamera()).isEmpty()) {
            camera.setEntityRepresentation((Entity)this);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("CooldownTime", this.getCooldownTime());
        tag.putInt("Cooldown", this.getCooldown());
        tag.putBoolean("Malfunctioned", this.isMalfunctioned());
        if (!this.getCamera().isEmpty()) {
            tag.put("Camera", this.getCamera().save((HolderLookup.Provider)this.registryAccess()));
        }
        this.redstoneControl.save(tag);
        if (!this.ownerPlayerId.equals(Util.NIL_UUID)) {
            tag.putUUID("Owner", this.ownerPlayerId);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setCooldownTime(tag.getInt("CooldownTime"));
        this.setCooldown(tag.getInt("Cooldown"));
        this.setMalfunctioned(tag.getBoolean("Malfunctioned"));
        this.setCamera(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("Camera")));
        this.redstoneControl.load(tag);
        if (tag.contains("Owner", 11)) {
            this.ownerPlayerId = tag.getUUID("Owner");
        }
    }

    public ItemStack getCamera() {
        return (ItemStack)this.getEntityData().get(DATA_ID_CAMERA);
    }

    public void setCamera(ItemStack cameraStack) {
        if (!(this.isClientSide() || !cameraStack.isEmpty() && CameraId.ofStack(this.getCamera()).matches(cameraStack))) {
            this.level().players().stream().filter(pl -> pl instanceof ServerPlayer && pl.containerMenu instanceof CameraOnStandAttachmentsMenu).forEach(pl -> ((ServerPlayer)pl).closeContainer());
        }
        this.getEntityData().set(DATA_ID_CAMERA, (Object)cameraStack);
    }

    public boolean isCameraActive() {
        CameraItem cameraItem;
        Item item = this.getCamera().getItem();
        return item instanceof CameraItem && (cameraItem = (CameraItem)item).isActive(this.getCamera());
    }

    public Optional<Player> getOwnerPlayer() {
        return Optional.ofNullable(this.level().getPlayerByUUID(this.ownerPlayerId));
    }

    public UUID getOwnerPlayerId() {
        return this.ownerPlayerId;
    }

    public void setOwnerPlayer(Player player) {
        this.ownerPlayerId = player.getUUID();
    }

    public Optional<? extends Player> getClosestPlayerInRange() {
        return this.level().players().stream().min(Comparator.comparingDouble(player -> player.distanceTo((Entity)this))).filter(this::isInRangeForPhoto);
    }

    public int getCooldownTime() {
        return (Integer)this.getEntityData().get(DATA_ID_COOLDOWN_TIME);
    }

    public void setCooldownTime(int cooldown) {
        this.getEntityData().set(DATA_ID_COOLDOWN_TIME, (Object)cooldown);
    }

    public int getCooldown() {
        return (Integer)this.getEntityData().get(DATA_ID_COOLDOWN);
    }

    public void setCooldown(int cooldown) {
        this.getEntityData().set(DATA_ID_COOLDOWN, (Object)cooldown);
    }

    public void startCooldown(int cooldown) {
        this.setCooldownTime(cooldown);
        this.setCooldown(cooldown);
    }

    public boolean isOnCooldown() {
        return this.getCooldown() > 0;
    }

    public float getCooldownPercent() {
        float cooldownTime = this.getCooldownTime();
        float cooldown = this.getCooldown();
        return Mth.clamp((float)(cooldown / cooldownTime), (float)0.0f, (float)1.0f);
    }

    public boolean isMalfunctioned() {
        return (Boolean)this.getEntityData().get(DATA_ID_MALFUNCTIONED);
    }

    public void setMalfunctioned(boolean malfunctioned) {
        this.getEntityData().set(DATA_ID_MALFUNCTIONED, (Object)malfunctioned);
    }

    public int getOperatorId() {
        return (Integer)this.getEntityData().get(DATA_ID_OPERATOR_ID);
    }

    @Nullable
    public CameraOperator operator() {
        CameraOperator operator;
        Entity entity;
        int id = this.getOperatorId();
        return id >= 0 && (entity = this.level().getEntity(id)) instanceof CameraOperator ? (operator = (CameraOperator)entity) : null;
    }

    public void setOperator(@Nullable CameraOperator operator) {
        this.getEntityData().set(DATA_ID_OPERATOR_ID, (Object)(operator != null ? operator.asOperatorEntity().getId() : -1));
    }

    public boolean isInRangeForPhoto(Player player) {
        return player.distanceTo((Entity)this) < (float)((Integer)Config.Server.CAMERA_STAND_WORKING_RANGE.get()).intValue();
    }

    @Override
    public Optional<Player> getPlayerExecutingExposure() {
        if (((Boolean)Config.Server.CAMERA_STAND_FALLBACK_TO_OTHER_PLAYERS.get()).booleanValue()) {
            return this.getOwnerPlayer().filter(this::isInRangeForPhoto).or(this::getClosestPlayerInRange);
        }
        return this.getOwnerPlayer().filter(this::isInRangeForPhoto);
    }

    @Override
    public Optional<Player> getPlayerAwardedForExposure() {
        return this.getOwnerPlayer().or(this::getClosestPlayerInRange);
    }

    @Override
    @NotNull
    public Entity getExposureAuthorEntity() {
        return this.getOwnerPlayer().or(this::getClosestPlayerInRange).map(pl -> pl).orElse(this);
    }

    @Override
    public Optional<CameraOperator> getExposureCameraOperator() {
        return Optional.ofNullable(this.operator());
    }

    public boolean isInInteractionRange(LivingEntity entity) {
        double range = entity.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        return this.getBoundingBox().distanceToSqr(entity.getEyePosition()) < range * range;
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.canUse(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.exposure.camera_stand.error.in_use").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (this.isMalfunctioned()) {
            if (!this.isClientSide()) {
                this.setMalfunctioned(false);
                player.displayClientMessage((Component)Component.translatable((String)"gui.exposure.camera_stand.malfunction_fixed"), true);
                this.playSound(SoundEvents.SMITHING_TABLE_USE, 0.9f, 1.3f);
                this.showRepairingParticles();
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack handStack = player.getItemInHand(hand);
        ItemStack cameraStack = this.getCamera();
        if (handStack.is(Items.DEBUG_STICK) && !cameraStack.isEmpty()) {
            this.malfunction();
            return InteractionResult.SUCCESS;
        }
        if (cameraStack.isEmpty() && handStack.getItem() instanceof CameraItem) {
            this.setCamera(handStack);
            player.setItemInHand(hand, ItemStack.EMPTY);
            if (!this.isClientSide()) {
                this.playCameraSetSound();
            }
            if (this.getYRot() == 0.0f && this.getXRot() == 0.0f) {
                this.setYRot(Mth.wrapDegrees((float)player.getYRot()));
                if (!this.isClientSide()) {
                    this.syncRotationToClients();
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (cameraStack.isEmpty()) {
            return InteractionResult.PASS;
        }
        Item item = cameraStack.getItem();
        if (!(item instanceof CameraItem)) {
            return InteractionResult.PASS;
        }
        CameraItem cameraItem = (CameraItem)item;
        if (player.isSecondaryUseActive()) {
            return this.handleSneakInteraction(player, hand, cameraItem, cameraStack, handStack);
        }
        this.startControlling(player, cameraItem);
        return InteractionResult.CONSUME;
    }

    protected InteractionResult handleSneakInteraction(Player player, InteractionHand hand, CameraItem cameraItem, ItemStack cameraStack, ItemStack handStack) {
        if (this.isOnCooldown()) {
            return InteractionResult.FAIL;
        }
        if (cameraItem.getShutter().isOpen(cameraStack)) {
            return InteractionResult.FAIL;
        }
        if (handStack.isEmpty() && cameraItem.hasAttachmentsMenu()) {
            return this.openAttachmentsMenu(player, hand);
        }
        InteractionResult result = cameraItem.handleStandSneakInteraction(this, player, hand, cameraStack);
        if (result == InteractionResult.FAIL) {
            return InteractionResult.FAIL;
        }
        if (result == InteractionResult.PASS) {
            return cameraItem.hasAttachmentsMenu() ? this.openAttachmentsMenu(player, hand) : InteractionResult.PASS;
        }
        cameraItem.getTimer().stop(cameraStack);
        this.forceUpdate();
        return result;
    }

    public boolean canUse(Player player) {
        return (this.operator() == null || player.equals((Object)this.operator())) && this.level().players().stream().filter(pl -> !pl.equals((Object)player)).noneMatch(pl -> pl.containerMenu instanceof CameraOnStandAttachmentsMenu);
    }

    public InteractionResult openAttachmentsMenu(Player player, InteractionHand hand) {
        Item item;
        if (!this.canUse(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.exposure.camera_stand.error.in_use").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        final ItemStack cameraStack = this.getCamera();
        if (cameraStack.isEmpty() || !((item = cameraStack.getItem()) instanceof CameraItem)) {
            return InteractionResult.FAIL;
        }
        CameraItem cameraItem = (CameraItem)item;
        if (cameraItem.getShutter().isOpen(cameraStack)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.exposure.camera.camera_attachments.fail.shutter_open").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        cameraItem.getOrCreateId(cameraStack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.setOperator((CameraOperator)serverPlayer);
            cameraItem.getTimer().stop(cameraStack);
            MenuProvider menuProvider = new MenuProvider(){

                @NotNull
                public Component getDisplayName() {
                    return cameraStack.get(DataComponents.CUSTOM_NAME) != null ? cameraStack.getHoverName() : Component.translatable((String)"container.exposure.camera");
                }

                @NotNull
                public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new CameraOnStandAttachmentsMenu(containerId, playerInventory, CameraStandEntity.this);
                }
            };
            this.forceUpdate();
            PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> buffer.writeInt(this.getId()));
        }
        cameraItem.setDisassembled(cameraStack, true);
        Sound.play((Entity)player, Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), SoundSource.PLAYERS, 0.9f, 0.9f, 0.2f);
        return InteractionResult.SUCCESS;
    }

    public void startControlling(Player player, CameraItem cameraItem) {
        cameraItem.activateOnStand(player, this.getCamera(), this);
        this.setOperator((CameraOperator)player);
        if (this.getOwnerPlayerId().equals(Util.NIL_UUID)) {
            this.setOwnerPlayer(player);
        }
        if (this.isClientSide()) {
            CameraClient.setCameraEntity(this);
            Minecrft.stopPlayerMovement();
        } else {
            this.forceUpdate();
        }
    }

    public void stopControlling() {
        CameraItem cameraItem;
        Object object = this.getCamera().getItem();
        if (object instanceof CameraItem && (cameraItem = (CameraItem)((Object)object)).isActive(this.getCamera())) {
            cameraItem.deactivate(this, this.getCamera());
        }
        if (this.operator() != null) {
            if (this.isClientSide()) {
                CameraClient.resetCameraEntity();
            } else {
                object = this.operator();
                if (object instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)object;
                    Packets.sendToClient(new CameraStandStopControllingS2CP(this.getId()), serverPlayer);
                }
            }
        }
        this.setOperator(null);
        if (!this.isClientSide()) {
            this.forceUpdate();
        }
    }

    public void release() {
        Item item;
        if (!this.isMalfunctioned() && !this.isOnCooldown() && (item = this.getCamera().getItem()) instanceof CameraItem) {
            CameraItem cameraItem = (CameraItem)item;
            this.getPlayerExecutingExposure().ifPresentOrElse(player -> cameraItem.release(this, this.getCamera()), this::malfunction);
            this.forceUpdate();
        }
    }

    protected void malfunction() {
        if (this.getCamera().isEmpty()) {
            return;
        }
        if (Config.Server.CAMERA_STAND_RANGE_MALFUNCTION.isFalse()) {
            return;
        }
        this.stopControlling();
        this.setMalfunctioned(true);
        this.playSound(Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get());
    }

    public void tick() {
        block9: {
            block12: {
                CameraOperator operator;
                block11: {
                    block10: {
                        CameraItem cameraItem;
                        CameraItem cameraItem2;
                        Item item;
                        int cooldown;
                        super.tick();
                        this.travel();
                        this.checkForBoats();
                        this.checkForMinecarts();
                        this.pushEntities();
                        if (this.getHurtTime() > 0) {
                            this.setHurtTime(this.getHurtTime() - 1);
                        }
                        if (this.getDamage() > 0.0f) {
                            this.setDamage(this.getDamage() - 1.0f);
                        }
                        if ((cooldown = this.getCooldown()) > 0) {
                            this.setCooldown(cooldown - 1);
                        }
                        this.redstoneControl.tick();
                        if (!this.isClientSide() && (item = this.getCamera().getItem()) instanceof CameraItem && (cameraItem2 = (CameraItem)item).tick(this, this.getCamera())) {
                            this.forceUpdate();
                        }
                        if (this.isClientSide()) break block9;
                        operator = this.operator();
                        if (operator != null) break block10;
                        Item item2 = this.getCamera().getItem();
                        if (item2 instanceof CameraItem && (cameraItem = (CameraItem)item2).isActive(this.getCamera())) {
                            cameraItem.deactivate(this, this.getCamera());
                        }
                        break block9;
                    }
                    if (this.isInInteractionRange(operator.asOperatorEntity())) break block11;
                    this.stopControlling();
                    break block9;
                }
                if (this.isCameraActive()) break block9;
                if (!(operator instanceof Player)) break block12;
                Player player = (Player)operator;
                if (player.containerMenu instanceof CameraOnStandAttachmentsMenu) break block9;
            }
            this.stopControlling();
        }
    }

    protected void travel() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.applyGravity();
        if (this.isInWater() && this.getFluidHeight(FluidTags.WATER) > (double)0.1f) {
            this.setUnderwaterMovement();
        } else if (this.isInLava() && this.getFluidHeight(FluidTags.LAVA) > (double)0.1f) {
            this.setUnderLavaMovement();
        }
        if (this.level().isClientSide) {
            this.noPhysics = false;
        } else {
            boolean bl = this.noPhysics = !this.level().noCollision((Entity)this, this.getBoundingBox().deflate(1.0E-7));
            if (this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
            }
        }
        if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            float f = 0.98f;
            if (this.onGround()) {
                f = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
            if (this.onGround()) {
                Vec3 vec32 = this.getDeltaMovement();
                if (vec32.y < 0.0) {
                    this.setDeltaMovement(vec32.multiply(1.0, -0.5, 1.0));
                }
            }
        }
    }

    protected void setUnderwaterMovement() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x * (double)0.9f, vec3.y * (double)0.23f, vec3.z * (double)0.9f);
    }

    protected void setUnderLavaMovement() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x * 0.5, vec3.y * (double)0.1f, vec3.z * 0.5);
    }

    protected void checkForBoats() {
        if (!this.isClientSide() && !this.isPassenger()) {
            List boats = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.4f, (double)0.2f, (double)0.4f), e -> e instanceof Boat);
            for (Entity entity : boats) {
                Boat boat = (Boat)entity;
                if (boat.getPassengers().size() >= 2 || !boat.hasEnoughSpaceFor((Entity)this)) continue;
                this.startRiding((Entity)boat);
            }
        }
    }

    protected void checkForMinecarts() {
        if (!this.isClientSide() && !this.isPassenger()) {
            List minecarts = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.4f, (double)0.2f, (double)0.4f), e -> {
                AbstractMinecart cart;
                return e instanceof AbstractMinecart && (cart = (AbstractMinecart)e).getMinecartType() == AbstractMinecart.Type.RIDEABLE;
            });
            for (Entity entity : minecarts) {
                AbstractMinecart minecart = (AbstractMinecart)entity;
                if (minecart.isVehicle()) continue;
                this.startRiding((Entity)minecart);
            }
        }
    }

    protected void pushEntities() {
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), RIDABLE_MINECARTS)) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push((Entity)this);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        if (!this.getCamera().isEmpty()) {
            if (!this.isClientSide()) {
                @Nullable ItemEntity itemEntity = this.spawnAtLocation(this.getCamera(), this.getEyeHeight());
                if (itemEntity != null) {
                    itemEntity.setPickUpDelay(5);
                }
                this.playCameraRemoveSound();
            }
            this.setCamera(ItemStack.EMPTY);
            if (source.isCreativePlayer()) {
                return true;
            }
            amount = 1.0f;
        }
        if (!this.isClientSide()) {
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.markHurt();
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
            this.playHitSound();
            if (source.isCreativePlayer()) {
                this.discard();
                this.showBreakingParticles();
                this.playBreakSound();
            } else if (this.getDamage() > 10.0f) {
                this.destroy(source);
                this.showBreakingParticles();
                this.playBreakSound();
            }
        }
        return true;
    }

    public void setHurtTime(int hurtTime) {
        this.entityData.set(DATA_ID_HURT, (Object)hurtTime);
    }

    public void setHurtDir(int hurtDir) {
        this.entityData.set(DATA_ID_HURTDIR, (Object)hurtDir);
    }

    public void setDamage(float damage) {
        this.entityData.set(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_ID_DAMAGE)).floatValue();
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return (Integer)this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(DamageSource source) {
        this.destroy(this.getDropItem());
    }

    public void destroy(Item dropItem) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemStack = new ItemStack((ItemLike)dropItem);
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            this.spawnAtLocation(itemStack, 0.5f);
        }
    }

    protected void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.25), this.getZ(), 6, (double)(this.getBbWidth() / 6.0f), (double)(this.getBbHeight() / 6.0f), (double)(this.getBbWidth() / 6.0f), 0.05);
        }
    }

    protected void showRepairingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.HOPPER.defaultBlockState()), this.getX(), this.getY(0.75), this.getZ(), 4, (double)(this.getBbWidth() / 8.0f), (double)(this.getBbHeight() / 8.0f), (double)(this.getBbWidth() / 8.0f), 0.05);
        }
    }

    protected Item getDropItem() {
        return Exposure.Items.CAMERA_STAND.get();
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.BLOCKS;
    }

    public void playPlaceSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Exposure.SoundEvents.CAMERA_STAND_PLACE.get(), this.getSoundSource(), 0.8f, 1.0f);
    }

    public void playHitSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Exposure.SoundEvents.CAMERA_STAND_HIT.get(), this.getSoundSource(), 0.8f, 1.0f);
    }

    public void playBreakSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Exposure.SoundEvents.CAMERA_STAND_BREAK.get(), this.getSoundSource(), 1.0f, 1.0f);
    }

    public void playCameraSetSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Exposure.SoundEvents.CAMERA_STAND_SET_CAMERA.get(), this.getSoundSource(), 0.8f, 1.0f);
    }

    public void playCameraRemoveSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Exposure.SoundEvents.CAMERA_STAND_REMOVE_CAMERA.get(), this.getSoundSource(), 0.8f, 1.0f);
    }

    public void forceUpdate() {
        this.getEntityData().set(DATA_ID_CAMERA, (Object)this.getCamera(), true);
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }

    public boolean isControlledByLocalInstance() {
        Player player;
        CameraOperator cameraOperator = this.operator();
        return cameraOperator instanceof Player && (player = (Player)cameraOperator).isLocalPlayer() || super.isControlledByLocalInstance();
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.setPos(x, y, z);
    }

    public void syncRotationToClientsIfNeeded() {
        if (this.isClientSide()) {
            return;
        }
        if (this.operator() != null || this.tickCount % 10 == 0) {
            this.syncRotationToClients();
        }
    }

    public void syncRotationToClients() {
        Packets.sendToClients(new CameraStandSetRotationsS2CP(this.getId(), this.getYRot(), this.getXRot()), pl -> !pl.equals((Object)this.operator()));
    }
}

