/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum FlashMode implements StringRepresentable
{
    OFF("off"),
    ON("on"),
    AUTO("auto");

    public static final Codec<FlashMode> CODEC;
    public static final StreamCodec<ByteBuf, FlashMode> STREAM_CODEC;
    private final String name;

    private FlashMode(String name) {
        this.name = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public MutableComponent translate() {
        return Component.translatable((String)("gui.exposure.flash_mode." + this.name));
    }

    static {
        CODEC = StringRepresentable.fromEnum(FlashMode::values);
        STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])FlashMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
    }
}

