/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.supporter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.supporter.Gilded;
import io.github.mortuusars.exposure.util.supporter.Patreon;
import io.github.mortuusars.exposure.util.supporter.Supporter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Supporters {
    private static final Gilded gilded = new Gilded();
    private static final Patreon patreon = new Patreon();

    public static void query() {
        gilded.query();
        patreon.query();
    }

    public static Gilded gilded() {
        return gilded;
    }

    public static Patreon patreon() {
        return patreon;
    }

    public static boolean hasAccessToGoldenSkin(UUID uuid) {
        return Supporters.gilded().hasAccessToGoldenSkin(uuid) || Supporters.patreon().hasAccessToGoldenSkin(uuid);
    }

    public static class Loader {
        public CompletableFuture<@Nullable String> readFileFromURL(URI uri) {
            HttpClient client = HttpClient.newHttpClient();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(uri).build();
                CompletionStage completionStage = ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).exceptionally(e -> {
                    Exposure.LOGGER.warn("Cannot get list of supporters.", e);
                    return null;
                });
                if (client != null) {
                    client.close();
                }
                return completionStage;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    Exposure.LOGGER.warn("Cannot get list of supporters from {}.", (Object)uri, (Object)e2);
                    return CompletableFuture.completedFuture(null);
                }
            }
        }

        @NotNull
        public List<Supporter> parseSupporters(String json) {
            Gson gson = new Gson();
            JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
            ArrayList<Supporter> supporters = new ArrayList<Supporter>();
            for (JsonElement element : array) {
                try {
                    Supporter p = (Supporter)gson.fromJson(element, Supporter.class);
                    supporters.add(p);
                }
                catch (Exception e) {
                    Exposure.LOGGER.warn("Cannot parse supporter from '{}'", (Object)element, (Object)e);
                }
            }
            return supporters;
        }
    }
}

