/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.supporter;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.supporter.Supporter;
import io.github.mortuusars.exposure.util.supporter.Supporters;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Patreon {
    private long lastQueryTime = -1L;
    @Nullable
    private Map<Tier, List<Supporter>> patrons = null;

    public boolean canQuery() {
        return System.currentTimeMillis() - this.lastQueryTime > 60000L;
    }

    @NotNull
    public Map<Tier, List<Supporter>> getOrQuery() {
        if (this.patrons != null) {
            return this.patrons;
        }
        if (!this.canQuery()) {
            return Collections.emptyMap();
        }
        return this.query();
    }

    @NotNull
    public Map<Tier, List<Supporter>> query() {
        this.lastQueryTime = System.currentTimeMillis();
        try {
            Supporters.Loader loader = new Supporters.Loader();
            for (Tier patreonTier : Tier.values()) {
                ((CompletableFuture)loader.readFileFromURL(patreonTier.getUuidsUri()).thenAccept(json -> {
                    if (json == null) {
                        return;
                    }
                    List<Supporter> parsedSupporters = loader.parseSupporters((String)json);
                    if (this.patrons == null) {
                        this.patrons = new HashMap<Tier, List<Supporter>>();
                    }
                    this.patrons.put(patreonTier, parsedSupporters);
                })).exceptionally(e -> {
                    Exposure.LOGGER.warn("Cannot get list of supporters.", e);
                    return null;
                });
            }
        }
        catch (Exception e2) {
            Exposure.LOGGER.warn("Cannot get list of supporters.", (Throwable)e2);
        }
        if (this.patrons == null) {
            return Collections.emptyMap();
        }
        return this.patrons;
    }

    public boolean hasAccessToGoldenSkin(UUID uuid) {
        Map<Tier, List<Supporter>> patrons = this.getOrQuery();
        return patrons.getOrDefault((Object)Tier.GOLD, Collections.emptyList()).stream().anyMatch(s -> s.matches(uuid)) || patrons.getOrDefault((Object)Tier.DIAMOND, Collections.emptyList()).stream().anyMatch(s -> s.matches(uuid));
    }

    public static enum Tier {
        COPPER,
        IRON,
        GOLD,
        DIAMOND;


        public URI getUuidsUri() {
            return URI.create("https://raw.githubusercontent.com/mortuusars/resources/refs/heads/main/supporters/patreon/uuids/" + this.name().toLowerCase() + ".json");
        }
    }
}

