/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.clientbound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record CameraStandSetRotationsS2CP(int entityId, float yRot, float xRot) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("camera_stand_set_rotations");
    public static final CustomPacketPayload.Type<CameraStandSetRotationsS2CP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, CameraStandSetRotationsS2CP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CameraStandSetRotationsS2CP::entityId, (StreamCodec)ByteBufCodecs.FLOAT, CameraStandSetRotationsS2CP::yRot, (StreamCodec)ByteBufCodecs.FLOAT, CameraStandSetRotationsS2CP::xRot, CameraStandSetRotationsS2CP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        Entity entity = player.level().getEntity(this.entityId);
        if (entity instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)entity;
            stand.setYRot(this.yRot);
            stand.setXRot(this.xRot);
        }
        return true;
    }
}

