/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.clientbound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record ActiveCameraInHandSetS2CP(int operatorEntityId, CameraId cameraId, InteractionHand hand) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("active_camera_in_hand_set");
    public static final CustomPacketPayload.Type<ActiveCameraInHandSetS2CP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ActiveCameraInHandSetS2CP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ActiveCameraInHandSetS2CP::operatorEntityId, CameraId.STREAM_CODEC, ActiveCameraInHandSetS2CP::cameraId, (StreamCodec)ByteBufCodecs.VAR_INT.map(i -> InteractionHand.values()[i], Enum::ordinal), ActiveCameraInHandSetS2CP::hand, ActiveCameraInHandSetS2CP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow flow, Player player) {
        LivingEntity entity;
        Entity entity2 = player.level().getEntity(this.operatorEntityId);
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2) instanceof CameraOperator) {
            CameraOperator operator = (CameraOperator)entity;
            if (entity instanceof CameraHolder) {
                CameraHolder holder = (CameraHolder)entity;
                operator.setActiveExposureCamera(new CameraInHand(holder, this.cameraId, this.hand));
            }
        }
        return true;
    }
}

