/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.world.item.AlbumItem;
import io.github.mortuusars.exposure.world.item.SignedAlbumItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LecternBlockEntity.class})
public abstract class LecternBlockEntityMixin {
    @Shadow
    public abstract ItemStack getBook();

    @Inject(method={"hasBook()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHasBook(CallbackInfoReturnable<Boolean> cir) {
        if (this.getBook().getItem() instanceof AlbumItem || this.getBook().getItem() instanceof SignedAlbumItem) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getPageCount(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onGetPageCount(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        Item item = stack.getItem();
        if (item instanceof AlbumItem) {
            AlbumItem albumItem = (AlbumItem)item;
            cir.setReturnValue((Object)albumItem.getContent(stack).pages().size());
        } else {
            item = stack.getItem();
            if (item instanceof SignedAlbumItem) {
                SignedAlbumItem signedAlbumItem = (SignedAlbumItem)item;
                cir.setReturnValue((Object)signedAlbumItem.getContent(stack).pages().size());
            }
        }
    }
}

