/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.jei;

import com.google.common.collect.ImmutableList;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.gui.screen.ItemRenameScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumScreen;
import io.github.mortuusars.exposure.integration.jei.category.PhotographPrintingCategory;
import io.github.mortuusars.exposure.integration.jei.category.PhotographStackingCategory;
import io.github.mortuusars.exposure.integration.jei.neoforge.ExposureJeiPluginImpl;
import io.github.mortuusars.exposure.integration.jei.recipe.ComponentTransferringShapelessExtension;
import io.github.mortuusars.exposure.integration.jei.recipe.PhotographPrintingJeiRecipe;
import io.github.mortuusars.exposure.integration.jei.recipe.PhotographStackingJeiRecipe;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.item.crafting.recipe.ComponentTransferringRecipe;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ExposureJeiPlugin
implements IModPlugin {
    public static final RecipeType<PhotographPrintingJeiRecipe> PHOTOGRAPH_PRINTING_RECIPE_TYPE = RecipeType.create((String)"exposure", (String)"photograph_printing", PhotographPrintingJeiRecipe.class);
    public static final RecipeType<PhotographStackingJeiRecipe> PHOTOGRAPH_STACKING_RECIPE_TYPE = RecipeType.create((String)"exposure", (String)"photograph_stacking", PhotographStackingJeiRecipe.class);
    private static final ResourceLocation ID = Exposure.resource("jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PhotographPrintingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PhotographStackingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Exposure.Items.LIGHTROOM.get()), new RecipeType[]{PHOTOGRAPH_PRINTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Exposure.Items.STACKED_PHOTOGRAPHS.get()), new RecipeType[]{PHOTOGRAPH_STACKING_RECIPE_TYPE});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(PHOTOGRAPH_PRINTING_RECIPE_TYPE, (List)ImmutableList.of((Object)new PhotographPrintingJeiRecipe(ExposureType.BLACK_AND_WHITE), (Object)new PhotographPrintingJeiRecipe(ExposureType.COLOR)));
        registration.addRecipes(PHOTOGRAPH_STACKING_RECIPE_TYPE, (List)ImmutableList.of((Object)new PhotographStackingJeiRecipe(0), (Object)new PhotographStackingJeiRecipe(1)));
        if (((Boolean)Config.Client.SHOW_JEI_INFORMATION.get()).booleanValue()) {
            registration.addItemStackInfo(List.of(new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH_FRAME.get()), new ItemStack((ItemLike)Exposure.Items.CLEAR_PHOTOGRAPH_FRAME.get())), new Component[]{Component.translatable((String)"exposure.jei.info.photograph_frame")});
        }
        if (PlatformHelper.isModLoaded("create")) {
            ExposureJeiPlugin.addSequencedDevelopingRecipes(registration);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addSequencedDevelopingRecipes(@NotNull IRecipeRegistration registration) {
        ExposureJeiPluginImpl.addSequencedDevelopingRecipes(registration);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(ComponentTransferringRecipe.class, (ICraftingCategoryExtension)new ComponentTransferringShapelessExtension());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AlbumScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<AlbumScreen>(this){

            @NotNull
            public List<Rect2i> getGuiExtraAreas(@NotNull AlbumScreen containerScreen) {
                return List.of(new Rect2i(0, 0, Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight()));
            }
        });
        registration.addGenericGuiContainerHandler(ItemRenameScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<ItemRenameScreen>(this){

            @NotNull
            public List<Rect2i> getGuiExtraAreas(@NotNull ItemRenameScreen containerScreen) {
                return List.of(new Rect2i(0, 0, Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight()));
            }
        });
    }
}

