/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera;

import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderRegistry;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.common.ActiveCameraDeactivateCommonPacket;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraClient {
    @Nullable
    private static Viewfinder activeViewfinder;

    public static void tick() {
        if (activeViewfinder != null) {
            activeViewfinder.tick();
        }
    }

    public static Optional<Camera> getActive() {
        return Minecrft.player().getActiveExposureCameraOptional();
    }

    public static boolean isActive() {
        return CameraClient.getActive().isPresent();
    }

    public static void deactivate() {
        Minecrft.player().getActiveExposureCameraOptional().ifPresent(camera -> {
            camera.map((item, stack) -> item.deactivate(camera.getHolder().asHolderEntity(), (ItemStack)stack));
            Minecrft.player().removeActiveExposureCamera();
        });
        Packets.sendToServer(ActiveCameraDeactivateCommonPacket.INSTANCE);
    }

    public static void setCameraEntity(Entity entity) {
        Minecrft.get().cameraEntity = entity;
        Minecrft.get().gameRenderer.getMainCamera().eyeHeight = entity.getEyeHeight();
        Minecrft.get().gameRenderer.getMainCamera().eyeHeightOld = entity.getEyeHeight();
        Minecrft.get().gameRenderer.getMainCamera().reset();
    }

    public static void resetCameraEntity() {
        CameraClient.setCameraEntity((Entity)Minecrft.player());
    }

    @Nullable
    public static Viewfinder viewfinder() {
        return activeViewfinder;
    }

    public static void setupViewfinder(@NotNull Camera camera) {
        CameraClient.removeViewfinder();
        activeViewfinder = ViewfinderRegistry.get(camera);
        if (camera instanceof CameraOnStand) {
            Minecrft.options().setCameraType(CameraType.FIRST_PERSON);
        }
    }

    public static void removeViewfinder() {
        if (activeViewfinder != null) {
            activeViewfinder.close();
            activeViewfinder = null;
        }
    }
}

