/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.predicate;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.util.ExtraData;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record ExtraDataPredicate(ExtraData data) {
    public static final Codec<ExtraDataPredicate> CODEC = TagParser.LENIENT_CODEC.xmap(tag -> new ExtraDataPredicate(new ExtraData((CompoundTag)tag)), predicate -> predicate.data);
    public static final StreamCodec<ByteBuf, ExtraDataPredicate> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(tag -> new ExtraDataPredicate(new ExtraData((CompoundTag)tag)), predicate -> predicate.data);

    public boolean matches(@Nullable Tag tag) {
        return tag != null && this.compareNbt(tag);
    }

    private boolean compareNbt(@Nullable Tag other) {
        if (this.data == other) {
            return true;
        }
        if (this.data == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        ExtraData extraData = this.data;
        if (extraData instanceof CompoundTag) {
            ExtraData compoundTag = extraData;
            CompoundTag compoundTag2 = (CompoundTag)other;
            if (compoundTag2.size() < compoundTag.size()) {
                return false;
            }
            for (String string : compoundTag.getAllKeys()) {
                Tag tag2 = compoundTag.get(string);
                if (NbtUtils.compareNbt((Tag)tag2, (Tag)compoundTag2.get(string), (boolean)true)) continue;
                return false;
            }
            return true;
        }
        return this.data.equals(other);
    }
}

