/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.mixin;

import com.anthonyhilyard.iceberg.util.ITooltipAccess;
import com.anthonyhilyard.iceberg.util.Tooltips;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1002)
public class GuiGraphicsMixin {
    private static Method renderTooltipsMethod = null;
    private boolean tooltipsDisplayed;

    private static boolean renderComparisonTooltips(GuiGraphics graphics, ClientTooltipPositioner positioner, int x, int y, ItemStack itemStack, Minecraft minecraft, Font font, Screen screen) {
        try {
            if (renderTooltipsMethod == null) {
                renderTooltipsMethod = Class.forName("com.anthonyhilyard.equipmentcompare.gui.ComparisonTooltips").getDeclaredMethod("render", GuiGraphics.class, ClientTooltipPositioner.class, Integer.TYPE, Integer.TYPE, ItemStack.class, Minecraft.class, Font.class, Screen.class);
            }
            return (Boolean)renderTooltipsMethod.invoke(null, graphics, positioner, x, y, itemStack, minecraft, font, screen);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Inject(method={"renderTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderTooltip(Font font, ItemStack itemStack, int x, int y, CallbackInfo info) {
        GuiGraphics self = (GuiGraphics)this;
        Minecraft minecraft = Minecraft.getInstance();
        Screen currentScreen = minecraft.screen;
        this.tooltipsDisplayed = false;
        if (GuiGraphicsMixin.renderComparisonTooltips(self, DefaultTooltipPositioner.INSTANCE, x, y, itemStack, minecraft, font, currentScreen)) {
            this.tooltipsDisplayed = true;
            info.cancel();
        } else if (currentScreen instanceof AbstractContainerScreen) {
            ItemStack hoveredStack;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)currentScreen;
            ItemStack itemStack2 = hoveredStack = containerScreen.hoveredSlot != null && containerScreen.hoveredSlot.hasItem() ? containerScreen.hoveredSlot.getItem() : ItemStack.EMPTY;
            if (GuiGraphicsMixin.renderComparisonTooltips(self, DefaultTooltipPositioner.INSTANCE, x, y, hoveredStack, minecraft, font, (Screen)containerScreen)) {
                this.tooltipsDisplayed = true;
                info.cancel();
            }
        }
    }

    @Inject(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderTooltipInternal(Font font, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, CallbackInfo info) {
        Tooltips.TooltipRenderContext context;
        GuiGraphics self = (GuiGraphics)this;
        ITooltipAccess tooltipAccess = (ITooltipAccess)this;
        Minecraft minecraft = Minecraft.getInstance();
        Screen currentScreen = minecraft.screen;
        ItemStack tooltipStack = tooltipAccess.getIcebergTooltipStack();
        if (!this.tooltipsDisplayed && tooltipStack != ItemStack.EMPTY && (context = Tooltips.getCurrentRenderContext()) == Tooltips.EMPTY_CONTEXT && GuiGraphicsMixin.renderComparisonTooltips(self, positioner, x, y, tooltipStack, minecraft, font, currentScreen)) {
            tooltipAccess.setIcebergTooltipStack(ItemStack.EMPTY);
            info.cancel();
        }
    }
}

