/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.screen;

import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VehicleScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final InventoryVehicleEntity vehicle;

    public VehicleScreenHandler(int syncId, Inventory playerInventory, InventoryVehicleEntity vehicle) {
        super(null, syncId);
        this.vehicle = vehicle;
        this.inventory = vehicle.getInventory();
        this.inventory.startOpen(playerInventory.player);
        for (SlotDescription slot : this.vehicle.getInventoryDescription().getSlots()) {
            this.addSlot(slot.getSlot(vehicle, this.inventory));
        }
        int h = this.vehicle.getInventoryDescription().getHeight() + 20;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, h + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + x * 18, h + 58));
        }
    }

    public boolean stillValid(Player player) {
        return this.vehicle.getInventory() == this.inventory && this.inventory.stillValid(player) && this.vehicle.isAlive() && this.vehicle.distanceTo((Entity)player) < 8.0f;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (index < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean unused) {
        ItemStack target;
        Slot slot;
        int i;
        boolean inserted = false;
        if (stack.isStackable()) {
            for (i = startIndex; !stack.isEmpty() && i < endIndex; ++i) {
                int maxCount;
                slot = (Slot)this.slots.get(i);
                target = slot.getItem();
                if (target.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)target)) continue;
                int diff = target.getCount() + stack.getCount();
                if (diff <= (maxCount = slot.getMaxStackSize(stack))) {
                    stack.setCount(0);
                    target.setCount(diff);
                    slot.setChanged();
                    inserted = true;
                    continue;
                }
                if (target.getCount() >= maxCount) continue;
                stack.shrink(maxCount - target.getCount());
                target.setCount(maxCount);
                slot.setChanged();
                inserted = true;
            }
        }
        if (!stack.isEmpty()) {
            for (i = startIndex; i < endIndex; ++i) {
                slot = (Slot)this.slots.get(i);
                target = slot.getItem();
                int maxCount = slot.getMaxStackSize(target);
                if (!target.isEmpty() || !slot.mayPlace(stack)) continue;
                if (stack.getCount() > maxCount) {
                    slot.setByPlayer(stack.split(maxCount));
                } else {
                    slot.setByPlayer(stack.split(stack.getCount()));
                }
                slot.setChanged();
                inserted = true;
                break;
            }
        }
        return inserted;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public InventoryVehicleEntity getVehicle() {
        return this.vehicle;
    }
}

