/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.s2c;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;

public class VehicleUpgradesMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, VehicleUpgradesMessage> STREAM_CODEC = StreamCodec.ofMember(VehicleUpgradesMessage::encode, VehicleUpgradesMessage::new);
    public static final CustomPacketPayload.Type<VehicleUpgradesMessage> TYPE = Message.createType("vehicle_upgrades");
    private final Map<Item, VehicleUpgrade> upgrades;

    public CustomPacketPayload.Type<VehicleUpgradesMessage> type() {
        return TYPE;
    }

    public VehicleUpgradesMessage() {
        this.upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
    }

    public VehicleUpgradesMessage(RegistryFriendlyByteBuf buffer) {
        this.upgrades = new HashMap<Item, VehicleUpgrade>();
        int upgradeCount = buffer.readInt();
        for (int i = 0; i < upgradeCount; ++i) {
            Item item = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
            this.upgrades.put(item, this.readUpgrade(buffer));
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        Map<Item, VehicleUpgrade> upgrades = VehicleUpgradeRegistry.INSTANCE.getAll();
        buffer.writeInt(upgrades.size());
        for (Item item : upgrades.keySet()) {
            buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)item));
            this.writeUpgrade(buffer, upgrades.get(item));
        }
    }

    protected void writeUpgrade(RegistryFriendlyByteBuf buffer, VehicleUpgrade upgrade) {
        Map<VehicleStat, Float> upgradeMap = upgrade.getAll();
        buffer.writeInt(upgradeMap.size());
        for (VehicleStat stat : upgradeMap.keySet()) {
            buffer.writeUtf(stat.name());
            buffer.writeFloat(upgradeMap.get(stat).floatValue());
        }
    }

    protected VehicleUpgrade readUpgrade(RegistryFriendlyByteBuf buffer) {
        VehicleUpgrade upgrade = new VehicleUpgrade();
        int statCount = buffer.readInt();
        for (int j = 0; j < statCount; ++j) {
            upgrade.set(VehicleStat.STATS.get(buffer.readUtf()), buffer.readFloat());
        }
        return upgrade;
    }

    @Override
    public void receiveClient() {
        VehicleUpgradeRegistry.INSTANCE.replace(this.upgrades);
    }
}

