/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import immersive_aircraft.Main;
import immersive_aircraft.entity.misc.Trail;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Vector3f;

public class TrailRenderer {
    private static final ResourceLocation identifier = Main.locate("textures/entity/trail.png");

    public static void render(Trail trail, MultiBufferSource vertexConsumerProvider, PoseStack.Pose matrices) {
        if (trail.nullEntries >= trail.size || trail.entries == 0) {
            return;
        }
        VertexConsumer lineVertexConsumer = vertexConsumerProvider.getBuffer(RenderType.beaconBeam((ResourceLocation)identifier, (boolean)true));
        int light = 0xF00000;
        Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Matrix3f matrix = matrices.normal();
        for (int i = 1; i < Math.min(trail.entries, trail.size); ++i) {
            int pre = (i + trail.lastIndex - 1) % trail.size * 7;
            int index = (i + trail.lastIndex) % trail.size * 7;
            int a1 = (int)((1.0f - (float)i / (float)trail.size * 255.0f) * trail.buffer[pre + 6]);
            int a2 = i == trail.size - 1 ? 0 : (int)((1.0f - ((float)i + 1.0f) / (float)trail.size * 255.0f) * trail.buffer[index + 6]);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 0.0f, pre, pos, a1, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 1.0f, pre + 3, pos, a1, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 1.0f, index + 3, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 0.0f, index, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 0.0f, index, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 1.0f, index + 3, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 1.0f, pre + 3, pos, a1, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 0.0f, pre, pos, a1, light);
        }
    }

    private static void vertex(Trail trail, VertexConsumer lineVertexConsumer, Matrix3f matrix, float u, float v, int index, Vec3 pos, float a, int light) {
        Vector3f p = new Vector3f((float)((double)trail.buffer[index] - pos.x), (float)((double)trail.buffer[index + 1] - pos.y), (float)((double)trail.buffer[index + 2] - pos.z));
        matrix.transform(p);
        lineVertexConsumer.addVertex(p.x, p.y, p.z).setColor(trail.gray, trail.gray, trail.gray, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
    }
}

