/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft;

import immersive_aircraft.Entities;
import immersive_aircraft.Main;
import immersive_aircraft.cobalt.registration.Registration;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.BiplaneEntity;
import immersive_aircraft.entity.CargoAirshipEntity;
import immersive_aircraft.entity.GyrodyneEntity;
import immersive_aircraft.entity.QuadrocopterEntity;
import immersive_aircraft.entity.WarshipEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.item.AircraftItem;
import immersive_aircraft.item.DyeableAircraftItem;
import immersive_aircraft.item.WeaponItem;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface Items {
    public static final List<Supplier<Item>> items = new LinkedList<Supplier<Item>>();
    public static final Supplier<Item> HULL = Items.register("hull", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> ENGINE = Items.register("engine", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> SAIL = Items.register("sail", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> PROPELLER = Items.register("propeller", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> BOILER = Items.register("boiler", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> AIRSHIP = Items.register("airship", () -> new DyeableAircraftItem(Items.baseProps().stacksTo(1), world -> new AirshipEntity(Entities.AIRSHIP.get(), world)));
    public static final Supplier<Item> CARGO_AIRSHIP = Items.register("cargo_airship", () -> new DyeableAircraftItem(Items.baseProps().stacksTo(1), world -> new CargoAirshipEntity(Entities.CARGO_AIRSHIP.get(), world)));
    public static final Supplier<Item> WARSHIP = Items.register("warship", () -> new DyeableAircraftItem(Items.baseProps().stacksTo(1), world -> new WarshipEntity(Entities.WARSHIP.get(), world)));
    public static final Supplier<Item> BIPLANE = Items.register("biplane", () -> new AircraftItem(Items.baseProps().stacksTo(1), world -> new BiplaneEntity(Entities.BIPLANE.get(), world)));
    public static final Supplier<Item> GYRODYNE = Items.register("gyrodyne", () -> new AircraftItem(Items.baseProps().stacksTo(1), world -> new GyrodyneEntity(Entities.GYRODYNE.get(), world)));
    public static final Supplier<Item> QUADROCOPTER = Items.register("quadrocopter", () -> new AircraftItem(Items.baseProps().stacksTo(1), world -> new QuadrocopterEntity(Entities.QUADROCOPTER.get(), world)));
    public static final Supplier<Item> ROTARY_CANNON = Items.register("rotary_cannon", () -> new WeaponItem(Items.baseProps().stacksTo(1), WeaponMount.Type.ROTATING));
    public static final Supplier<Item> HEAVY_CROSSBOW = Items.register("heavy_crossbow", () -> new WeaponItem(Items.baseProps().stacksTo(1), WeaponMount.Type.FRONT));
    public static final Supplier<Item> TELESCOPE = Items.register("telescope", () -> new WeaponItem(Items.baseProps().stacksTo(1), WeaponMount.Type.ROTATING));
    public static final Supplier<Item> BOMB_BAY = Items.register("bomb_bay", () -> new WeaponItem(Items.baseProps().stacksTo(1), WeaponMount.Type.DROP));
    public static final Supplier<Item> ENHANCED_PROPELLER = Items.register("enhanced_propeller", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> ECO_ENGINE = Items.register("eco_engine", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> NETHER_ENGINE = Items.register("nether_engine", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> STEEL_BOILER = Items.register("steel_boiler", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> INDUSTRIAL_GEARS = Items.register("industrial_gears", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> STURDY_PIPES = Items.register("sturdy_pipes", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> GYROSCOPE = Items.register("gyroscope", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> HULL_REINFORCEMENT = Items.register("hull_reinforcement", () -> new Item(Items.baseProps().stacksTo(8)));
    public static final Supplier<Item> IMPROVED_LANDING_GEAR = Items.register("improved_landing_gear", () -> new Item(Items.baseProps().stacksTo(8)));

    public static Supplier<Item> register(String name, Supplier<Item> item) {
        Supplier<Item> register = Registration.register(BuiltInRegistries.ITEM, Main.locate(name), item);
        items.add(register);
        return register;
    }

    public static void bootstrap() {
    }

    public static Item.Properties baseProps() {
        return new Item.Properties();
    }

    public static List<ItemStack> getSortedItems() {
        return items.stream().map(i -> ((Item)i.get()).getDefaultInstance()).toList();
    }
}

