/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft;

import immersive_aircraft.Main;
import immersive_aircraft.client.KeyBindings;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.network.ClientMessageHandler;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;

public class ClientMain {
    private static int activeTicks;
    private static boolean isZooming;
    private static CameraType perspectiveBeforeZoom;
    private static boolean isInVehicle;
    private static CameraType lastPerspective;
    private static long lastTime;

    public static void postLoad() {
        Main.messageHandler = new ClientMessageHandler();
        Main.cameraGetter = () -> Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Main.firstPersonGetter = () -> Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON;
    }

    public static void tick() {
        Entity entity;
        Minecraft client = Minecraft.getInstance();
        Main.frameTime = client.getTimer().getGameTimeDeltaTicks();
        if (client.level == null || client.level.getGameTime() == lastTime) {
            return;
        }
        lastTime = client.level.getGameTime();
        if (Config.getInstance().separateCamera) {
            boolean b;
            LocalPlayer player = client.player;
            boolean bl = b = player != null && player.getRootVehicle() instanceof VehicleEntity;
            if (b != isInVehicle) {
                if (lastPerspective == null) {
                    lastPerspective = Config.getInstance().useThirdPersonByDefault ? CameraType.THIRD_PERSON_BACK : CameraType.FIRST_PERSON;
                }
                isInVehicle = b;
                CameraType perspective = client.options.getCameraType();
                client.options.setCameraType(lastPerspective);
                lastPerspective = perspective;
            }
        }
        if (client.player != null && (entity = client.player.getVehicle()) instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)entity;
            if (vehicle.isScoping() != isZooming) {
                isZooming = vehicle.isScoping();
                if (isZooming) {
                    perspectiveBeforeZoom = client.options.getCameraType();
                    client.options.setCameraType(CameraType.FIRST_PERSON);
                } else {
                    client.options.setCameraType(perspectiveBeforeZoom);
                }
            }
            if (++activeTicks > 20 && KeyBindings.use.isDown() && client.player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                vehicle.clientFireWeapons((Entity)client.player);
            }
        } else {
            activeTicks = 0;
        }
    }
}

