/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.creeperhost.levelio.data.Chunk;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBTQuickSearch
extends DataInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(NBTQuickSearch.class);
    private static final int END = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int INT = 3;
    private static final int LONG = 4;
    private static final int FLOAT = 5;
    private static final int DOUBLE = 6;
    private static final int BYTE_ARRAY = 7;
    private static final int STRING = 8;
    private static final int LIST = 9;
    private static final int COMPOUND = 10;
    private static final int INT_ARRAY = 11;
    private static final int LONG_ARRAY = 12;
    private static final int[] TYPE_LENGTH = new int[]{-1, 1, 2, 4, 8, 4, 8, -1, -1, -1, -1, -1, -1};

    public NBTQuickSearch(InputStream is) {
        super(is);
    }

    @Nullable
    public static NBTQuickSearch fromChunk(ByteBuffer buffer) {
        if (buffer.capacity() == 0) {
            return null;
        }
        byte compression = Chunk.getCompression(buffer);
        InputStream is = new ByteArrayInputStream(buffer.array(), 5, Chunk.getDataLength(buffer));
        if (compression > 0 && compression <= 2) {
            try {
                is = compression == 1 ? new GZIPInputStream(is) : new InflaterInputStream(is);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when trying to decompress NBT stream", (Throwable)e);
                return null;
            }
        } else if (compression != 0) {
            LOGGER.warn("NBTQuickSearch does not support extended chunk data format");
            return null;
        }
        return new NBTQuickSearch(is);
    }

    public boolean findTag(String tagName) throws IOException {
        byte id = this.readByte();
        this.readUTF();
        if (id == 10) {
            return this.searchCompound(tagName);
        }
        return false;
    }

    private boolean searchCompound(String tagName) throws IOException {
        block5: while (true) {
            byte id = this.readByte();
            switch (id) {
                case 0: {
                    return false;
                }
                case 10: {
                    this.readUTF();
                    if (!this.searchCompound(tagName)) continue block5;
                    return true;
                }
                case 9: {
                    this.readUTF();
                    if (!this.searchList(tagName)) continue block5;
                    return true;
                }
            }
            String name = this.readUTF();
            if (tagName.equals(name)) {
                return true;
            }
            this.skip(id, 1);
        }
    }

    private boolean searchList(String tagName) throws IOException {
        byte listType = this.readByte();
        int length = this.readInt();
        if (length == 0) {
            return false;
        }
        if (listType == 10) {
            for (int i = 0; i < length; ++i) {
                if (!this.searchCompound(tagName)) continue;
                return true;
            }
        } else if (listType == 9) {
            for (int i = 0; i < length; ++i) {
                if (!this.searchList(tagName)) continue;
                return true;
            }
        } else {
            this.skip(listType, length);
        }
        return false;
    }

    private void skip(int id, int count) throws IOException {
        switch (id) {
            case 7: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readInt());
                }
                return;
            }
            case 11: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readInt() * 4);
                }
                return;
            }
            case 12: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readInt() * 8);
                }
                return;
            }
            case 8: {
                for (int i = 0; i < count; ++i) {
                    this.skipBytes(this.readUnsignedShort());
                }
                return;
            }
        }
        this.skipBytes(TYPE_LENGTH[id] * count);
    }
}

