/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.data;

import java.util.Objects;
import net.creeperhost.ftbbackups.config.Format;

public class Backup {
    private String worldName;
    private long createTime;
    private String backupLocation;
    private long size;
    private float ratio;
    private String sha1;
    private String preview;
    private boolean snapshot;
    private String backupName;
    private Format backupFormat;
    private boolean complete;

    public Backup() {
        this.complete = true;
    }

    public Backup(String worldName, long createTime, String backupLocation, long size, float ratio, String sha1, String preview, boolean snapshot, String backupName, Format backupFormat, boolean complete) {
        this.worldName = worldName;
        this.createTime = createTime;
        this.backupLocation = backupLocation;
        this.size = size;
        this.ratio = ratio;
        this.sha1 = sha1;
        this.preview = preview;
        this.snapshot = snapshot;
        this.backupName = backupName;
        this.backupFormat = backupFormat;
        this.complete = complete;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getSha1() {
        return this.sha1;
    }

    public boolean isProtected() {
        return this.snapshot;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public float getRatio() {
        return this.ratio;
    }

    public String getBackupLocation() {
        return this.backupLocation;
    }

    public String getBackupName() {
        return this.backupName;
    }

    public Format getBackupFormat() {
        return this.backupFormat;
    }

    public Backup setRatio(float ratio) {
        this.ratio = ratio;
        return this;
    }

    public Backup setSha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    public Backup setComplete() {
        this.complete = true;
        return this;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Backup backup = (Backup)o;
        return this.createTime == backup.createTime && this.size == backup.size && Float.compare(backup.ratio, this.ratio) == 0 && this.snapshot == backup.snapshot && Objects.equals(this.worldName, backup.worldName) && Objects.equals(this.backupLocation, backup.backupLocation) && Objects.equals(this.sha1, backup.sha1) && Objects.equals(this.preview, backup.preview) && Objects.equals(this.backupName, backup.backupName) && this.backupFormat == backup.backupFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.worldName, this.createTime, this.backupLocation, this.size, Float.valueOf(this.ratio), this.sha1, this.preview, this.snapshot, this.backupName, this.backupFormat});
    }
}

