/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.Delta;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.w3c.dom.Element;

public class CollapsibleContainer
extends FlowLayout {
    public static final Surface SURFACE = (context, component) -> context.fill(component.x() + 5, component.y(), component.x() + 6, component.y() + component.height(), 0x77FFFFFF);
    protected final EventStream<OnToggled> toggledEvents = OnToggled.newStream();
    protected final List<io.wispforest.owo.ui.core.Component> collapsibleChildren = new ArrayList<io.wispforest.owo.ui.core.Component>();
    protected final List<io.wispforest.owo.ui.core.Component> collapsibleChildrenView = Collections.unmodifiableList(this.collapsibleChildren);
    protected boolean expanded;
    protected final SpinnyBoiComponent spinnyBoi;
    protected final FlowLayout titleLayout = Containers.horizontalFlow(Sizing.content(), Sizing.content());
    protected final FlowLayout contentLayout;

    protected CollapsibleContainer(Sizing horizontalSizing, Sizing verticalSizing, Component title, boolean expanded) {
        super(horizontalSizing, verticalSizing, FlowLayout.Algorithm.VERTICAL);
        this.titleLayout.padding(Insets.of(5, 5, 5, 0));
        this.allowOverflow(true);
        title = title.copy().withStyle(ChatFormatting.UNDERLINE);
        this.titleLayout.child(Components.label(title).cursorStyle(CursorStyle.HAND));
        this.spinnyBoi = new SpinnyBoiComponent();
        this.titleLayout.child(this.spinnyBoi);
        this.expanded = expanded;
        this.spinnyBoi.rotation = this.spinnyBoi.targetRotation = expanded ? 90.0f : 0.0f;
        super.child(this.titleLayout);
        this.contentLayout = Containers.verticalFlow(Sizing.content(), Sizing.content());
        this.contentLayout.padding(Insets.left(15));
        this.contentLayout.surface(SURFACE);
        super.child(this.contentLayout);
    }

    public FlowLayout titleLayout() {
        return this.titleLayout;
    }

    public List<io.wispforest.owo.ui.core.Component> collapsibleChildren() {
        return this.collapsibleChildrenView;
    }

    public boolean expanded() {
        return this.expanded;
    }

    public EventSource<OnToggled> onToggled() {
        return this.toggledEvents.source();
    }

    public void toggleExpansion() {
        if (this.expanded) {
            this.contentLayout.clearChildren();
            this.spinnyBoi.targetRotation = 0.0f;
        } else {
            this.contentLayout.children(this.collapsibleChildren);
            this.spinnyBoi.targetRotation = 90.0f;
        }
        this.expanded = !this.expanded;
        this.toggledEvents.sink().onToggle(this.expanded);
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.KEYBOARD_CYCLE;
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32 || keyCode == 257 || keyCode == 335) {
            this.toggleExpansion();
            super.onKeyPress(keyCode, scanCode, modifiers);
            return true;
        }
        return super.onKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        boolean superResult = super.onMouseDown(mouseX, mouseY, button);
        if (mouseY <= (double)this.titleLayout.fullSize().height() && !superResult) {
            this.toggleExpansion();
            UISounds.playInteractionSound();
            return true;
        }
        return superResult;
    }

    @Override
    public FlowLayout child(io.wispforest.owo.ui.core.Component child) {
        this.collapsibleChildren.add(child);
        if (this.expanded) {
            this.contentLayout.child(child);
        }
        return this;
    }

    @Override
    public FlowLayout children(Collection<? extends io.wispforest.owo.ui.core.Component> children) {
        this.collapsibleChildren.addAll(children);
        if (this.expanded) {
            this.contentLayout.children(children);
        }
        return this;
    }

    @Override
    public FlowLayout child(int index, io.wispforest.owo.ui.core.Component child) {
        this.collapsibleChildren.add(index, child);
        if (this.expanded) {
            this.contentLayout.child(index, child);
        }
        return this;
    }

    @Override
    public FlowLayout children(int index, Collection<? extends io.wispforest.owo.ui.core.Component> children) {
        this.collapsibleChildren.addAll(index, children);
        if (this.expanded) {
            this.contentLayout.children(index, children);
        }
        return this;
    }

    @Override
    public FlowLayout removeChild(io.wispforest.owo.ui.core.Component child) {
        this.collapsibleChildren.remove(child);
        return this.contentLayout.removeChild(child);
    }

    public static CollapsibleContainer parse(Element element) {
        Element textElement = UIParsing.childElements(element).get("text");
        MutableComponent title = textElement == null ? Component.empty() : UIParsing.parseText(textElement);
        return element.getAttribute("expanded").equals("true") ? Containers.collapsible(Sizing.content(), Sizing.content(), (Component)title, true) : Containers.collapsible(Sizing.content(), Sizing.content(), (Component)title, false);
    }

    public static interface OnToggled {
        public void onToggle(boolean var1);

        public static EventStream<OnToggled> newStream() {
            return new EventStream<OnToggled>(subscribers -> nowExpanded -> {
                for (OnToggled subscriber : subscribers) {
                    subscriber.onToggle(nowExpanded);
                }
            });
        }
    }

    protected static class SpinnyBoiComponent
    extends LabelComponent {
        protected float rotation = 90.0f;
        protected float targetRotation = 90.0f;

        public SpinnyBoiComponent() {
            super((Component)Component.literal((String)">"));
            this.margins(Insets.of(0, 0, 5, 10));
            this.cursorStyle(CursorStyle.HAND);
        }

        @Override
        public void update(float delta, int mouseX, int mouseY) {
            super.update(delta, mouseX, mouseY);
            this.rotation = (float)((double)this.rotation + Delta.compute((double)this.rotation, (double)this.targetRotation, (double)delta * 0.65));
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            PoseStack matrices = context.pose();
            matrices.pushPose();
            matrices.translate((float)this.x + (float)this.width / 2.0f - 1.0f, (float)this.y + (float)this.height / 2.0f - 1.0f, 0.0f);
            matrices.mulPose(Axis.ZP.rotationDegrees(this.rotation));
            matrices.translate(-((float)this.x + (float)this.width / 2.0f - 1.0f), -((float)this.y + (float)this.height / 2.0f - 1.0f), 0.0f);
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            matrices.popPose();
        }
    }
}

