/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.shader;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.owo.mixin.shader.ShaderProgramAccessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class GlProgram {
    private static final List<Tuple<Function<ResourceProvider, ShaderInstance>, Consumer<ShaderInstance>>> REGISTERED_PROGRAMS = new ArrayList<Tuple<Function<ResourceProvider, ShaderInstance>, Consumer<ShaderInstance>>>();
    protected ShaderInstance backingProgram;

    public GlProgram(ResourceLocation id, VertexFormat vertexFormat) {
        REGISTERED_PROGRAMS.add((Tuple<Function<ResourceProvider, ShaderInstance>, Consumer<ShaderInstance>>)new Tuple(resourceFactory -> {
            try {
                return new OwoShaderProgram((ResourceProvider)resourceFactory, id, vertexFormat);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialized owo shader program", e);
            }
        }, program -> {
            this.backingProgram = program;
            this.setup();
        }));
    }

    public void use() {
        RenderSystem.setShader(() -> this.backingProgram);
    }

    protected void setup() {
    }

    @Nullable
    protected Uniform findUniform(String name) {
        return ((ShaderProgramAccessor)this.backingProgram).owo$getLoadedUniforms().get(name);
    }

    @ApiStatus.Internal
    public static void forEachProgram(Consumer<Tuple<Function<ResourceProvider, ShaderInstance>, Consumer<ShaderInstance>>> loader) {
        REGISTERED_PROGRAMS.forEach(loader);
    }

    public static class OwoShaderProgram
    extends ShaderInstance {
        private OwoShaderProgram(ResourceProvider factory, ResourceLocation id, VertexFormat format) throws IOException {
            super(factory, id, format);
        }
    }
}

