/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;

public class MechanicalCraftingRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private boolean acceptMirrored;
    private List<ICondition> recipeConditions;

    public MechanicalCraftingRecipeBuilder(ItemLike p_i48261_1_, int p_i48261_2_) {
        this.result = p_i48261_1_.asItem();
        this.count = p_i48261_2_;
        this.acceptMirrored = true;
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(ItemLike p_200470_0_) {
        return MechanicalCraftingRecipeBuilder.shapedRecipe(p_200470_0_, 1);
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(ItemLike p_200468_0_, int p_200468_1_) {
        return new MechanicalCraftingRecipeBuilder(p_200468_0_, p_200468_1_);
    }

    public MechanicalCraftingRecipeBuilder key(Character p_200469_1_, TagKey<Item> p_200469_2_) {
        return this.key(p_200469_1_, Ingredient.of(p_200469_2_));
    }

    public MechanicalCraftingRecipeBuilder key(Character p_200462_1_, ItemLike p_200462_2_) {
        return this.key(p_200462_1_, Ingredient.of((ItemLike[])new ItemLike[]{p_200462_2_}));
    }

    public MechanicalCraftingRecipeBuilder key(Character p_200471_1_, Ingredient p_200471_2_) {
        if (this.key.containsKey(p_200471_1_)) {
            throw new IllegalArgumentException("Symbol '" + p_200471_1_ + "' is already defined!");
        }
        if (p_200471_1_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_200471_1_, p_200471_2_);
        return this;
    }

    public MechanicalCraftingRecipeBuilder patternLine(String p_200472_1_) {
        if (!this.pattern.isEmpty() && p_200472_1_.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(p_200472_1_);
        return this;
    }

    public MechanicalCraftingRecipeBuilder disallowMirrored() {
        this.acceptMirrored = false;
        return this;
    }

    public void build(RecipeOutput output) {
        this.build(output, RegisteredObjectsHelper.getKeyOrThrow((Item)this.result));
    }

    public void build(RecipeOutput output, String id) {
        ResourceLocation resourcelocation = RegisteredObjectsHelper.getKeyOrThrow((Item)this.result);
        if (ResourceLocation.parse((String)id).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + id + " should remove its 'save' argument");
        }
        this.build(output, ResourceLocation.parse((String)id));
    }

    public void build(RecipeOutput output, ResourceLocation id) {
        this.validate(id);
        MechanicalCraftingRecipe recipe = new MechanicalCraftingRecipe("", CraftingBookCategory.MISC, ShapedRecipePattern.of(this.key, this.pattern), new ItemStack((ItemLike)this.result, this.count), this.acceptMirrored);
        output.accept(id, (Recipe)recipe, null, this.recipeConditions.toArray(new ICondition[0]));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(id) + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(id) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(id));
        }
    }

    public MechanicalCraftingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public MechanicalCraftingRecipeBuilder whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public MechanicalCraftingRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }
}

