/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data.recipe;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public abstract class CreateRecipeProvider
extends RecipeProvider {
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public CreateRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
        this.all.forEach(c -> c.register(pRecipeOutput));
        Create.LOGGER.info("{} registered {} recipe{}", new Object[]{this.getName(), this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(RecipeOutput var1);
    }

    protected static class I {
        protected I() {
        }

        static TagKey<Item> redstone() {
            return Tags.Items.DUSTS_REDSTONE;
        }

        static TagKey<Item> planks() {
            return ItemTags.PLANKS;
        }

        static TagKey<Item> woodSlab() {
            return ItemTags.WOODEN_SLABS;
        }

        static TagKey<Item> gold() {
            return Tags.Items.INGOTS_GOLD;
        }

        static TagKey<Item> goldSheet() {
            return AllTags.commonItemTag("plates/gold");
        }

        static TagKey<Item> stone() {
            return Tags.Items.STONES;
        }

        static ItemLike andesiteAlloy() {
            return (ItemLike)AllItems.ANDESITE_ALLOY.get();
        }

        static ItemLike shaft() {
            return (ItemLike)AllBlocks.SHAFT.get();
        }

        static ItemLike cog() {
            return (ItemLike)AllBlocks.COGWHEEL.get();
        }

        static ItemLike largeCog() {
            return (ItemLike)AllBlocks.LARGE_COGWHEEL.get();
        }

        static ItemLike andesiteCasing() {
            return (ItemLike)AllBlocks.ANDESITE_CASING.get();
        }

        static ItemLike vault() {
            return (ItemLike)AllBlocks.ITEM_VAULT.get();
        }

        static ItemLike stockLink() {
            return (ItemLike)AllBlocks.STOCK_LINK.get();
        }

        static TagKey<Item> brass() {
            return AllTags.commonItemTag("ingots/brass");
        }

        static TagKey<Item> brassSheet() {
            return AllTags.commonItemTag("plates/brass");
        }

        static TagKey<Item> iron() {
            return Tags.Items.INGOTS_IRON;
        }

        static TagKey<Item> ironNugget() {
            return Tags.Items.NUGGETS_IRON;
        }

        static TagKey<Item> zinc() {
            return AllTags.commonItemTag("ingots/zinc");
        }

        static TagKey<Item> ironSheet() {
            return AllTags.commonItemTag("plates/iron");
        }

        static TagKey<Item> sturdySheet() {
            return AllTags.commonItemTag("plates/obsidian");
        }

        static ItemLike brassCasing() {
            return (ItemLike)AllBlocks.BRASS_CASING.get();
        }

        static ItemLike cardboard() {
            return (ItemLike)AllItems.CARDBOARD.get();
        }

        static ItemLike railwayCasing() {
            return (ItemLike)AllBlocks.RAILWAY_CASING.get();
        }

        static ItemLike electronTube() {
            return (ItemLike)AllItems.ELECTRON_TUBE.get();
        }

        static ItemLike precisionMechanism() {
            return (ItemLike)AllItems.PRECISION_MECHANISM.get();
        }

        static TagKey<Item> brassBlock() {
            return AllTags.commonItemTag("storage_blocks/brass");
        }

        static TagKey<Item> zincBlock() {
            return AllTags.commonItemTag("storage_blocks/zinc");
        }

        static TagKey<Item> wheatFlour() {
            return AllTags.commonItemTag("flours/wheat");
        }

        static TagKey<Item> copper() {
            return Tags.Items.INGOTS_COPPER;
        }

        static TagKey<Item> copperNugget() {
            return AllTags.commonItemTag("nuggets/copper");
        }

        static TagKey<Item> copperBlock() {
            return Tags.Items.STORAGE_BLOCKS_COPPER;
        }

        static TagKey<Item> copperSheet() {
            return AllTags.commonItemTag("plates/copper");
        }

        static TagKey<Item> brassNugget() {
            return AllTags.commonItemTag("nuggets/brass");
        }

        static TagKey<Item> zincNugget() {
            return AllTags.commonItemTag("nuggets/zinc");
        }

        static ItemLike copperCasing() {
            return (ItemLike)AllBlocks.COPPER_CASING.get();
        }

        static ItemLike refinedRadiance() {
            return (ItemLike)AllItems.REFINED_RADIANCE.get();
        }

        static ItemLike shadowSteel() {
            return (ItemLike)AllItems.SHADOW_STEEL.get();
        }

        static Ingredient netherite() {
            return Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE);
        }
    }

    protected static class Marker {
        protected Marker() {
        }
    }
}

