/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.sequenced;

import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;

public class SequencedRecipe<T extends ProcessingRecipe<?>> {
    public static final Codec<SequencedRecipe<?>> CODEC = AllRecipeTypes.CODEC.dispatch(ProcessingRecipe::getRecipeType, AllRecipeTypes::processingCodec).validate(r -> r instanceof IAssemblyRecipe ? DataResult.success((Object)r) : DataResult.error(() -> String.valueOf(r.getType()) + " is not a supported recipe type")).xmap(SequencedRecipe::new, SequencedRecipe::getRecipe);
    public static final StreamCodec<RegistryFriendlyByteBuf, SequencedRecipe<?>> STREAM_CODEC = StreamCodec.of((b, v) -> v.writeToBuffer((RegistryFriendlyByteBuf)b), SequencedRecipe::readFromBuffer);
    private final T wrapped;

    public SequencedRecipe(T wrapped) {
        this.wrapped = wrapped;
    }

    public IAssemblyRecipe getAsAssemblyRecipe() {
        return (IAssemblyRecipe)this.wrapped;
    }

    public ProcessingRecipe<?> getRecipe() {
        return this.wrapped;
    }

    private void writeToBuffer(RegistryFriendlyByteBuf buffer) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).getSerializer();
        buffer.writeResourceLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer));
        serializer.STREAM_CODEC.encode((Object)buffer, this.wrapped);
    }

    private static SequencedRecipe<?> readFromBuffer(RegistryFriendlyByteBuf buffer) {
        ResourceLocation resourcelocation = buffer.readResourceLocation();
        RecipeSerializer serializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(resourcelocation);
        if (!(serializer instanceof ProcessingRecipeSerializer)) {
            throw new JsonParseException("Not a supported recipe type");
        }
        ProcessingRecipeSerializer processingRecipeSerializer = (ProcessingRecipeSerializer)serializer;
        ProcessingRecipe recipe = (ProcessingRecipe)processingRecipeSerializer.STREAM_CODEC.decode((Object)buffer);
        return new SequencedRecipe<ProcessingRecipe>(recipe);
    }

    void initFromSequencedAssembly(SequencedAssemblyRecipe parent, boolean isFirst) {
        if (this.getAsAssemblyRecipe().supportsAssembly()) {
            Ingredient transit = Ingredient.of((ItemStack[])new ItemStack[]{parent.getTransitionalItem()});
            ((ProcessingRecipe)this.wrapped).getIngredients().set(0, (Object)(isFirst ? CompoundIngredient.of((Ingredient[])new Ingredient[]{transit, parent.getIngredient()}) : transit));
        }
    }
}

