/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetEmptyItem
extends Item {
    public static final String NAME = "easy_npc_preset_empty";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String FALL_DISTANCE_TAG = "FallDistance";
    private static final String FIRE_TAG = "Fire";
    private static final String ON_GROUND_TAG = "OnGround";
    private static final String SPAWN_DATA_TAG = "SpawnData";
    private static final String ID_TAG = "id";

    public EasyNPCPresetEmptyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity instanceof Player) {
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.level();
        if (livingEntity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)livingEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!AccessManager.hasAccess(serverPlayer, easyNPC)) {
                    return InteractionResult.FAIL;
                }
                ItemStack presetItemStack = this.createPresetItemStack(easyNPC);
                if (!presetItemStack.isEmpty()) {
                    if (!player.getInventory().add(presetItemStack)) {
                        player.drop(presetItemStack, false);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private ItemStack createPresetItemStack(EasyNPC<?> easyNPC) {
        de.markusbordihn.easynpc.entity.easynpc.data.PresetData presetData = easyNPC.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("Can't export preset data from {}", easyNPC);
            return ItemStack.EMPTY;
        }
        return this.createPresetItemStack(easyNPC.getLivingEntity().getType(), presetData.serializePresetData());
    }

    private ItemStack createPresetItemStack(EntityType<?> entityType, CompoundTag compoundTag) {
        Item item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"easy_npc_preset")).orElse(null);
        if (item == null) {
            log.error("Can't find item for storing preset {}", (Object)"easy_npc_preset");
            return ItemStack.EMPTY;
        }
        ResourceLocation entityTypeRegistryName = EntityType.getKey(entityType);
        if (compoundTag.contains(FIRE_TAG)) {
            compoundTag.remove(FIRE_TAG);
        }
        if (compoundTag.contains(FALL_DISTANCE_TAG)) {
            compoundTag.remove(FALL_DISTANCE_TAG);
        }
        if (compoundTag.contains(ON_GROUND_TAG)) {
            compoundTag.remove(ON_GROUND_TAG);
        }
        PresetData presetData = new PresetData(entityType, compoundTag);
        ItemStack presetItemStack = PresetData.set(item, presetData);
        new ItemStack((ItemLike)item);
        log.debug("Captured NPC preset from {} with {} to {}", (Object)entityTypeRegistryName, (Object)presetData, (Object)presetItemStack);
        return presetItemStack;
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        ItemStack presetItemStack;
        ResourceLocation entityRegistryName;
        EntityType entityType;
        SpawnData spawnData;
        CompoundTag entitySpawnData;
        EasyNPCSpawnerBlockEntity spawnerBlockEntity;
        BaseEasyNPCSpawner baseSpawner;
        CompoundTag compoundTag;
        BlockEntity blockEntity;
        Level level = useOnContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = useOnContext.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.isAir() && (blockEntity = level.getBlockEntity(blockPos)) instanceof EasyNPCSpawnerBlockEntity && (compoundTag = (baseSpawner = (spawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity).getSpawner()).save(new CompoundTag())) != null && compoundTag.contains(SPAWN_DATA_TAG) && (entitySpawnData = (spawnData = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getCompound(SPAWN_DATA_TAG)).resultOrPartial(string -> log.warn("Invalid SpawnData: {}", string)).orElseGet(SpawnData::new)).getEntityToSpawn()).contains(ID_TAG) && (entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityRegistryName = ResourceLocation.tryParse((String)entitySpawnData.getString(ID_TAG)))) != null && !(presetItemStack = this.createPresetItemStack(entityType, entitySpawnData.copy())).isEmpty()) {
            Player player = useOnContext.getPlayer();
            if (!player.getInventory().add(presetItemStack)) {
                player.drop(presetItemStack, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset_empty").withStyle(ChatFormatting.RED));
    }
}

