/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Chicken
extends EasyNPCBaseEntity<Chicken> {
    public static final String ID = "chicken";
    private float flap;
    private float flapSpeed;
    private float flapping = 1.0f;
    private float oFlap;
    private float oFlapSpeed;

    public Chicken(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level, Variant.WHITE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FLYING_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    public float getOFlap() {
        return this.oFlap;
    }

    public float getFlap() {
        return this.flap;
    }

    public float getOFlapSpeed() {
        return this.oFlapSpeed;
    }

    public float getFlapSpeed() {
        return this.flapSpeed;
    }

    public void aiFlappingStep() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.onGround() ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.aiFlappingStep();
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.CHICKEN;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.WHITE;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public int getEntityGuiScaling() {
        return 60;
    }

    @Override
    public int getEntityGuiTop() {
        return -5;
    }

    @Override
    public int getEntityDialogTop() {
        return -37;
    }

    @Override
    public int getEntityDialogScaling() {
        return 70;
    }

    @Override
    public boolean supportsSmartAnimations() {
        return false;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.CHICKEN_AMBIENT);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.CHICKEN_DEATH);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.CHICKEN_HURT);
        soundDataSet.addSound(SoundType.STEP, SoundEvents.CHICKEN_STEP);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum Variant {
        WHITE;

    }
}

