/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Cat
extends EasyNPCBaseEntity<Cat> {
    public static final String ID = "cat";

    public Cat(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level, Variant.BLACK);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.CAT;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.BLACK;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public int getEntityGuiScaling() {
        return 55;
    }

    @Override
    public int getEntityGuiTop() {
        return -10;
    }

    @Override
    public int getEntityDialogTop() {
        return -37;
    }

    @Override
    public int getEntityDialogScaling() {
        return 65;
    }

    @Override
    public boolean supportsSmartAnimations() {
        return false;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.CAT_AMBIENT);
        soundDataSet.addSound(SoundType.AMBIENT_TAMED, SoundEvents.CAT_PURREOW);
        soundDataSet.addSound(SoundType.AMBIENT_STRAY, SoundEvents.CAT_STRAY_AMBIENT);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.CAT_DEATH);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.CAT_HURT);
        soundDataSet.addSound(SoundType.EAT, SoundEvents.CAT_EAT);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum Variant {
        ALL_BLACK,
        BLACK,
        BRITISH_SHORTHAIR,
        CALICO,
        JELLIE,
        OCELOT,
        PERSIAN,
        RAGDOLL,
        RED,
        SIAMESE,
        TABBY,
        WHITE;

    }
}

