/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.event;

import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.portal.DimensionTransition;

public final class EasyNPCEventHandler {
    public static <E extends PathfinderMob> void handlePlayerJoinEvent(EasyNPC<E> easyNPC, ServerPlayer serverPlayer) {
        ObjectiveData objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onPlayerJoinUpdateObjective(serverPlayer);
        }
    }

    public static <E extends PathfinderMob> void handlePlayerLeaveEvent(EasyNPC<E> easyNPC, ServerPlayer serverPlayer) {
        ObjectiveData objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onPlayerLeaveUpdateObjective(serverPlayer);
        }
    }

    public static <E extends PathfinderMob> void handleLivingEntityJoinEvent(EasyNPC<E> easyNPC, LivingEntity livingEntity) {
        ObjectiveData objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onLivingEntityJoinUpdateObjective(livingEntity);
        }
    }

    public static <E extends PathfinderMob> void handleLivingEntityLeaveEvent(EasyNPC<E> easyNPC, LivingEntity livingEntity) {
        ObjectiveData objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null) {
            objectiveData.onLivingEntityLeaveUpdateObjective(livingEntity);
        }
    }

    public static <E extends PathfinderMob> void handleEasyNPCJoinEvent(EasyNPC<E> easyNPC, EasyNPC<?> entity) {
        ObjectiveData objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null && entity != null) {
            objectiveData.onEasyNPCJoinUpdateObjective(entity);
        }
    }

    public static <E extends PathfinderMob> void handleEasyNPCLeaveEvent(EasyNPC<E> easyNPC, EasyNPC<?> entity) {
        ObjectiveData objectiveData = easyNPC.getEasyNPCObjectiveData();
        if (objectiveData != null && entity != null) {
            objectiveData.onEasyNPCLeaveUpdateObjective(entity);
        }
    }

    public static <E extends PathfinderMob> void handleDieEvent(EasyNPC<E> easyNPC, DamageSource damageSource) {
        ActionEventData actionEventData;
        TradingData tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopTrading();
        }
        if ((actionEventData = easyNPC.getEasyNPCActionEventData()) != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_DEATH, EasyNPCEventHandler.getServerPlayerFromDamageSource(damageSource));
        }
    }

    public static <E extends PathfinderMob> void handleChangeDimensionEvent(EasyNPC<E> easyNPC, DimensionTransition dimensionTransition) {
        TradingData tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData != null) {
            tradingData.stopTrading();
        }
    }

    public static <E extends PathfinderMob> void handleHurtEvent(EasyNPC<E> easyNPC, DamageSource damageSource, float damage) {
        ActionEventData actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.handleActionEvent(ActionEventType.ON_HURT, EasyNPCEventHandler.getServerPlayerFromDamageSource(damageSource));
        }
    }

    private static ServerPlayer getServerPlayerFromDamageSource(DamageSource damageSource) {
        Projectile projectile;
        Entity entity = damageSource.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer;
        }
        Entity entity2 = damageSource.getDirectEntity();
        if (entity2 instanceof Projectile && (entity2 = (projectile = (Projectile)entity2).getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOfProjectile = (ServerPlayer)entity2;
            return serverPlayerOfProjectile;
        }
        return null;
    }
}

