/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigData;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.entity.easynpc.data.CustomAttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeData;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetData;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.entity.easynpc.data.ServerData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerData;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttributeHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.BaseTickHandler;
import java.util.EnumMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;

public interface EasyNPCBase<E extends PathfinderMob>
extends Saddleable,
EasyNPC<E>,
ActionEventData<E>,
ActionHandler<E>,
AttackData<E>,
AttributeData<E>,
AttributeHandler<E>,
BaseTickHandler<E>,
ConfigData<E>,
ConfigurationData<E>,
CustomAttributeData<E>,
DialogData<E>,
DisplayAttributeData<E>,
GuiData<E>,
ModelData<E>,
NavigationData<E>,
ObjectiveData<E>,
OwnerData<E>,
PresetData<E>,
ProfessionData<E>,
RenderData<E>,
ScaleData<E>,
ServerData<E>,
SkinData<E>,
SoundData<E>,
TickerData<E>,
TradingData<E>,
VariantData<E> {
    public static void registerEasyNPCSyncedData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        AttackData.registerSyncedAttackData(map, entityClass);
        AttributeData.registerSyncedAttributeData(map, entityClass);
        CustomAttributeData.registerSyncedCustomAttributeData(map, entityClass);
        DisplayAttributeData.registerSyncedDisplayAttributeData(map, entityClass);
        ModelData.registerSyncedModelData(map, entityClass);
        NavigationData.registerSyncedNavigationData(map, entityClass);
        OwnerData.registerSyncedOwnerData(map, entityClass);
        ProfessionData.registerSyncedProfessionData(map, entityClass);
        RenderData.registerSyncedRenderData(map, entityClass);
        ScaleData.registerSyncedScaleData(map, entityClass);
        SkinData.registerSyncedSkinData(map, entityClass);
        SoundData.registerSyncedSoundData(map, entityClass);
        TradingData.registerSyncedTradingData(map, entityClass);
        VariantData.registerSyncedVariantData(map, entityClass);
    }

    default public void registerEasyNPCDefaultHandler(Enum<?> variant) {
        SoundData soundData;
        log.info("Register default handler for {} with variant {} ...", (Object)this, variant);
        VariantData variantData = this.getEasyNPCVariantData();
        if (variantData != null) {
            variantData.setVariant(variant);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.registerDefaultSoundData(variant);
        }
    }

    default public SpawnGroupData finalizeEasyNPCSpawn(SpawnGroupData spawnGroupData) {
        ActionEventData actionEventData;
        ObjectiveData objectiveData;
        log.info("Finalize spawn for {} ...", (Object)this);
        NavigationData navigationData = this.getEasyNPCNavigationData();
        if (navigationData != null && !navigationData.hasHomePosition()) {
            navigationData.setHomePosition(this.getEntity().blockPosition());
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.registerStandardObjectives();
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.registerDefaultActionInteractionEvents();
        }
        return spawnGroupData;
    }

    default public void defineEasyNPCBaseSyncedData(SynchedEntityData.Builder builder) {
        TradingData tradingData;
        SoundData soundData;
        SkinData skinData;
        ScaleData scaleData;
        RenderData renderData;
        ProfessionData professionData;
        OwnerData ownerData;
        NavigationData navigationData;
        ModelData modelData;
        DisplayAttributeData displayAttributeData;
        DialogData dialogData;
        CustomAttributeData customAttributeData;
        AttributeData attributeData;
        AttackData attackData;
        ActionEventData actionEventData;
        log.debug("Define synced data for {} with {}", (Object)this, (Object)builder);
        VariantData variantData = this.getEasyNPCVariantData();
        if (variantData != null) {
            variantData.defineSynchedVariantData(builder);
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.defineSynchedActionData(builder);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.defineSynchedAttackData(builder);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.defineSynchedAttributeData(builder);
        }
        if ((customAttributeData = this.getEasyNPCCustomAttributeData()) != null) {
            customAttributeData.defineSynchedCustomAttributeData(builder);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.defineSynchedDialogData(builder);
        }
        if ((displayAttributeData = this.getEasyNPCDisplayAttributeData()) != null) {
            displayAttributeData.defineSynchedDisplayAttributeData(builder);
        }
        if ((modelData = this.getEasyNPCModelData()) != null) {
            modelData.defineSynchedModelData(builder);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.defineSynchedNavigationData(builder);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.defineSynchedOwnerData(builder);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.defineSynchedProfessionData(builder);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.defineSynchedRenderData(builder);
        }
        if ((scaleData = this.getEasyNPCScaleData()) != null) {
            scaleData.defineSynchedScaleData(builder);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.defineSynchedSkinData(builder);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.defineSynchedSoundData(builder);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.defineSynchedTradingData(builder);
        }
    }

    default public void defineEasyNPCBaseServerSideData() {
        PresetData presetData;
        ObjectiveData objectiveData;
        DialogData dialogData;
        if (!this.isServerSideInstance()) {
            return;
        }
        ServerData serverData = this.getEasyNPCServerData();
        if (serverData == null) {
            log.error("No server data available for {}", (Object)this.getEntityUUID());
            return;
        }
        if (!serverData.hasServerEntityData()) {
            log.info("Register server-side data for {} ...", (Object)this.getEntityUUID());
            serverData.defineServerEntityData();
        }
        log.info("Define custom server-side data for {} ...", (Object)this.getEntityUUID());
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.defineCustomActionData();
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.defineCustomDialogData();
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.defineCustomObjectiveData();
        }
        if ((presetData = this.getEasyNPCPresetData()) != null) {
            presetData.defineCustomPresetData();
        }
    }

    default public void addEasyNPCBaseAdditionalSaveData(CompoundTag compoundTag, HolderLookup.Provider provider) {
        VariantData variantData;
        TradingData tradingData;
        SoundData soundData;
        SkinData skinData;
        ScaleData scaleData;
        RenderData renderData;
        ProfessionData professionData;
        PresetData presetData;
        OwnerData ownerData;
        ObjectiveData objectiveData;
        NavigationData navigationData;
        ModelData modelData;
        DisplayAttributeData displayAttributeData;
        DialogData dialogData;
        ConfigData configData;
        CustomAttributeData customAttributeData;
        AttributeData attributeData;
        AttackData attackData;
        log.debug("Add additional save data for {} with {}", (Object)this, (Object)provider);
        ActionEventData actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData != null) {
            actionEventData.addAdditionalActionData(compoundTag);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.addAdditionalAttackData(compoundTag);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.addAdditionalAttributeData(compoundTag);
        }
        if ((customAttributeData = this.getEasyNPCCustomAttributeData()) != null) {
            customAttributeData.addAdditionalCustomAttributeData(compoundTag);
        }
        if ((configData = this.getEasyNPCConfigData()) != null) {
            configData.addAdditionalConfigData(compoundTag);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.addAdditionalDialogData(compoundTag);
        }
        if ((displayAttributeData = this.getEasyNPCDisplayAttributeData()) != null) {
            displayAttributeData.addAdditionalDisplayAttributeData(compoundTag);
        }
        if ((modelData = this.getEasyNPCModelData()) != null) {
            modelData.addAdditionalModelData(compoundTag);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.addAdditionalNavigationData(compoundTag);
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.addAdditionalObjectiveData(compoundTag);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.addAdditionalOwnerData(compoundTag);
        }
        if ((presetData = this.getEasyNPCPresetData()) != null) {
            presetData.addAdditionalPresetData(compoundTag);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.addAdditionalProfessionData(compoundTag);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.addAdditionalRenderData(compoundTag);
        }
        if ((scaleData = this.getEasyNPCScaleData()) != null) {
            scaleData.addAdditionalScaleData(compoundTag);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.addAdditionalSkinData(compoundTag);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.addAdditionalSoundData(compoundTag);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.addAdditionalTradingData(compoundTag, provider);
        }
        if ((variantData = this.getEasyNPCVariantData()) != null) {
            variantData.addAdditionalVariantData(compoundTag);
        }
    }

    default public void readEasyNPCBaseAdditionalSaveData(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ObjectiveData objectiveData;
        TradingData tradingData;
        SoundData soundData;
        SkinData skinData;
        ScaleData scaleData;
        RenderData renderData;
        ProfessionData professionData;
        PresetData presetData;
        OwnerData ownerData;
        NavigationData navigationData;
        ModelData modelData;
        DisplayAttributeData displayAttributeData;
        DialogData dialogData;
        CustomAttributeData customAttributeData;
        AttributeData attributeData;
        AttackData attackData;
        ActionEventData actionEventData;
        VariantData variantData;
        log.debug("Read additional save data for {} with {}", (Object)this, (Object)provider);
        ConfigData configData = this.getEasyNPCConfigData();
        if (configData != null) {
            configData.readAdditionalConfigData(compoundTag);
        }
        if ((variantData = this.getEasyNPCVariantData()) != null) {
            variantData.readAdditionalVariantData(compoundTag);
        }
        if ((actionEventData = this.getEasyNPCActionEventData()) != null) {
            actionEventData.readAdditionalActionData(compoundTag);
        }
        if ((attackData = this.getEasyNPCAttackData()) != null) {
            attackData.readAdditionalAttackData(compoundTag);
        }
        if ((attributeData = this.getEasyNPCAttributeData()) != null) {
            attributeData.readAdditionalAttributeData(compoundTag);
        }
        if ((customAttributeData = this.getEasyNPCCustomAttributeData()) != null) {
            customAttributeData.readAdditionalCustomAttributeData(compoundTag);
        }
        if ((dialogData = this.getEasyNPCDialogData()) != null) {
            dialogData.readAdditionalDialogData(compoundTag);
        }
        if ((displayAttributeData = this.getEasyNPCDisplayAttributeData()) != null) {
            displayAttributeData.readAdditionalDisplayAttributeData(compoundTag);
        }
        if ((modelData = this.getEasyNPCModelData()) != null) {
            modelData.readAdditionalModelData(compoundTag);
        }
        if ((navigationData = this.getEasyNPCNavigationData()) != null) {
            navigationData.readAdditionalNavigationData(compoundTag);
        }
        if ((ownerData = this.getEasyNPCOwnerData()) != null) {
            ownerData.readAdditionalOwnerData(compoundTag);
        }
        if ((presetData = this.getEasyNPCPresetData()) != null) {
            presetData.readAdditionalPresetData(compoundTag);
        }
        if ((professionData = this.getEasyNPCProfessionData()) != null) {
            professionData.readAdditionalProfessionData(compoundTag);
        }
        if ((renderData = this.getEasyNPCRenderData()) != null) {
            renderData.readAdditionalRenderData(compoundTag);
        }
        if ((scaleData = this.getEasyNPCScaleData()) != null) {
            scaleData.readAdditionalScaleData(compoundTag);
        }
        if ((skinData = this.getEasyNPCSkinData()) != null) {
            skinData.readAdditionalSkinData(compoundTag);
        }
        if ((soundData = this.getEasyNPCSoundData()) != null) {
            soundData.readAdditionalSoundData(compoundTag);
        }
        if ((tradingData = this.getEasyNPCTradingData()) != null) {
            tradingData.readAdditionalTradingData(compoundTag, provider);
        }
        if ((objectiveData = this.getEasyNPCObjectiveData()) != null) {
            objectiveData.readAdditionalObjectiveData(compoundTag);
        }
        if (navigationData != null) {
            navigationData.refreshGroundNavigation();
        }
    }
}

