/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionUtils;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ActionDataEntry(ActionDataType actionDataType, ConditionDataSet conditionDataSet, String command, BlockPos blockPos, boolean executeAsUser, boolean enableDebug, int permissionLevel) {
    public static final String DATA_TAG = "ActionDataEntry";
    public static final String DATA_COMMAND_TAG = "Cmd";
    public static final String DATA_DEBUG_TAG = "Debug";
    public static final String DATA_EXECUTE_AS_USER_TAG = "ExecAsUser";
    public static final String DATA_PERMISSION_LEVEL_TAG = "PermLevel";
    public static final String DATA_BLOCK_POS_TAG = "BlockPos";
    public static final String DATA_TYPE_TAG = "Type";
    public static final int DEFAULT_PERMISSION_LEVEL = 2;
    public static final int MAX_PERMISSION_LEVEL = 2;
    public static final int MIN_PERMISSION_LEVEL = 0;
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DEFAULT_COMMAND = "";

    public ActionDataEntry() {
        this(ActionDataType.COMMAND);
    }

    public ActionDataEntry(CompoundTag compoundTag) {
        this(ActionDataType.get(compoundTag.getString(DATA_TYPE_TAG)), compoundTag.contains("ConditionDataSet") ? new ConditionDataSet(compoundTag.getCompound("ConditionDataSet")) : new ConditionDataSet(), compoundTag.contains(DATA_COMMAND_TAG) ? compoundTag.getString(DATA_COMMAND_TAG) : DEFAULT_COMMAND, compoundTag.contains(DATA_BLOCK_POS_TAG) ? CompoundTagUtils.readBlockPos(compoundTag.getCompound(DATA_BLOCK_POS_TAG)) : BlockPos.ZERO, compoundTag.contains(DATA_EXECUTE_AS_USER_TAG) && compoundTag.getBoolean(DATA_EXECUTE_AS_USER_TAG), compoundTag.contains(DATA_DEBUG_TAG) && compoundTag.getBoolean(DATA_DEBUG_TAG), compoundTag.contains(DATA_PERMISSION_LEVEL_TAG) ? ActionDataEntry.checkPermissionLevel(compoundTag.getInt(DATA_PERMISSION_LEVEL_TAG)) : 2);
    }

    public ActionDataEntry(ActionDataType actionDataType) {
        this(actionDataType, DEFAULT_COMMAND, 2);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command) {
        this(actionDataType, command, 2);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, int permissionLevel) {
        this(actionDataType, command, permissionLevel, false);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, int permissionLevel, boolean executeAsUser) {
        this(actionDataType, command, permissionLevel, executeAsUser, false);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, boolean executeAsUser, boolean enableDebug) {
        this(actionDataType, command, 2, executeAsUser, enableDebug);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, int permissionLevel, boolean executeAsUser, boolean enableDebug) {
        this(actionDataType, new ConditionDataSet(), command != null ? command : DEFAULT_COMMAND, BlockPos.ZERO, executeAsUser, enableDebug, permissionLevel);
    }

    private static int checkPermissionLevel(int permissionLevel) {
        if (permissionLevel > 2) {
            log.warn("Permission level {} is too high, will be set to a safe max. level {}", (Object)permissionLevel, (Object)2);
            return 2;
        }
        if (permissionLevel < 0) {
            log.warn("Permission level {} is too low, will be set to min. level {}", (Object)permissionLevel, (Object)0);
            return 0;
        }
        return permissionLevel;
    }

    public ActionDataEntry withBlockPos(BlockPos blockPos) {
        return new ActionDataEntry(this.actionDataType, this.conditionDataSet, this.command, blockPos, this.enableDebug, this.executeAsUser, this.permissionLevel);
    }

    public String getAction(LivingEntity entity, ServerPlayer serverPlayer) {
        return ActionUtils.parseAction(this.command, entity, serverPlayer);
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public boolean hasCommandAndNotEmpty() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean hasBlockPos() {
        return this.blockPos != null && this.blockPos != BlockPos.ZERO;
    }

    public boolean isValid() {
        return this.actionDataType != ActionDataType.NONE && this.hasCommand();
    }

    public boolean isValidAndNotEmpty() {
        return this.actionDataType != ActionDataType.NONE && (!this.actionDataType.requiresArgument() || this.hasCommandAndNotEmpty() || this.hasBlockPos());
    }

    public ActionDataEntry create(CompoundTag compoundTag) {
        return new ActionDataEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.putString(DATA_TYPE_TAG, this.actionDataType.name());
        if (this.permissionLevel != 2) {
            compoundTag.putInt(DATA_PERMISSION_LEVEL_TAG, this.permissionLevel);
        }
        if (this.blockPos != BlockPos.ZERO) {
            compoundTag.put(DATA_BLOCK_POS_TAG, (Tag)CompoundTagUtils.writeBlockPos(this.blockPos));
        }
        if (this.command != null && !this.command.trim().isEmpty()) {
            compoundTag.putString(DATA_COMMAND_TAG, this.command.trim());
        }
        if (this.executeAsUser) {
            compoundTag.putBoolean(DATA_EXECUTE_AS_USER_TAG, true);
        }
        if (this.enableDebug) {
            compoundTag.putBoolean(DATA_DEBUG_TAG, true);
        }
        if (this.permissionLevel != 2) {
            compoundTag.putInt(DATA_PERMISSION_LEVEL_TAG, this.permissionLevel);
        }
        if (!this.conditionDataSet.isEmpty()) {
            this.conditionDataSet.save(compoundTag);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    public UUID getId() {
        String idString = DATA_TAG + this.hashCode();
        return UUID.nameUUIDFromBytes(idString.getBytes());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ActionDataEntry) {
            ActionDataEntry actionDataEntry = (ActionDataEntry)object;
            return this.actionDataType == actionDataEntry.actionDataType && this.command.equals(actionDataEntry.command) && this.blockPos.equals((Object)actionDataEntry.blockPos) && this.permissionLevel == actionDataEntry.permissionLevel && this.executeAsUser == actionDataEntry.executeAsUser && this.enableDebug == actionDataEntry.enableDebug && this.conditionDataSet.equals(actionDataEntry.conditionDataSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.actionDataType.hashCode();
        result = 31 * result + this.command.hashCode();
        result = 31 * result + this.blockPos.hashCode();
        result = 31 * result + this.permissionLevel;
        result = 31 * result + (this.executeAsUser ? 1 : 0);
        result = 31 * result + (this.enableDebug ? 1 : 0);
        if (this.conditionDataSet != null && !this.conditionDataSet.isEmpty()) {
            result = 31 * result + this.conditionDataSet.size();
        }
        return result;
    }

    @Override
    public String toString() {
        return "ActionData [type=" + String.valueOf((Object)this.actionDataType) + ", cmd=" + this.command + ", blockPos=" + String.valueOf(this.blockPos) + ", permLvl=" + this.permissionLevel + ", execAsUser=" + this.executeAsUser + ", debug=" + this.enableDebug + (String)(this.conditionDataSet != null && !this.conditionDataSet.isEmpty() ? ", conditions=" + String.valueOf(this.conditionDataSet) : DEFAULT_COMMAND) + "]";
    }
}

