/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class VariantOverLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final EasyNPCModelRenderer<?, ?> easyNPCModelRenderer;
    private final M model;

    public VariantOverLayer(RenderLayerParent<T, M> renderer, EntityModelSet model) {
        super(renderer);
        EasyNPCModelRenderer easyNPCModelRendererInstance;
        this.easyNPCModelRenderer = renderer instanceof EasyNPCModelRenderer ? (easyNPCModelRendererInstance = (EasyNPCModelRenderer)renderer) : null;
        this.model = renderer.getModel();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int lightLevel, T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float ageInTicks2, float netHeadYaw, float headPitch) {
        if (livingEntity.isInvisible() || this.easyNPCModelRenderer == null || !(livingEntity instanceof EasyNPC)) {
            return;
        }
        EasyNPC easyNPC = (EasyNPC)livingEntity;
        ResourceLocation resourceLocation = this.easyNPCModelRenderer.getTextureOverlayByVariant(easyNPC.getEasyNPCVariantData().getVariant());
        if (resourceLocation != null) {
            VariantOverLayer.renderColoredCutoutModel(this.model, (ResourceLocation)resourceLocation, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)lightLevel, livingEntity, (int)0xFFFFFF);
        }
    }
}

