/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class OuterLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final Map<?, ResourceLocation> textures;
    private final M model;

    public OuterLayer(RenderLayerParent<T, M> renderer, EntityModelSet entityModelSet, Map<?, ResourceLocation> textures) {
        super(renderer);
        this.textures = textures;
        this.model = renderer.getModel();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int lightLevel, T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float ageInTicks2, float netHeadYaw, float headPitch) {
        if (livingEntity.isInvisible() || this.textures == null || !(livingEntity instanceof EasyNPC)) {
            return;
        }
        EasyNPC easyNPC = (EasyNPC)livingEntity;
        ResourceLocation resourceLocation = this.textures.get(easyNPC.getEasyNPCVariantData().getVariant());
        if (resourceLocation != null) {
            OuterLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.model, (ResourceLocation)resourceLocation, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)lightLevel, livingEntity, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks2, (float)netHeadYaw, (float)headPitch, (float)ageInTicks, (int)0xFFFFFF);
        }
    }
}

