/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.custom.FairyModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.Fairy;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class FairyModelRenderer
extends BaseHumanoidMobModelRenderer<Fairy, Fairy.Variant, FairyModel<Fairy>> {
    protected static final Map<Fairy.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Fairy.Variant.class), map -> {
        map.put(Fairy.Variant.BLUE, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/fairy/fairy_blue.png"));
        map.put(Fairy.Variant.GREEN, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/fairy/fairy_green.png"));
        map.put(Fairy.Variant.RED, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/fairy/fairy_red.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Fairy.Variant.GREEN);

    public FairyModelRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new FairyModel(context.bakeLayer(modelLayerLocation)), 0.3f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
    }

    @Override
    public <N extends EasyNPC<Fairy>> void rotateEntity(N easyNPC, PoseStack poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.translate(0.0, 0.5, 0.0);
            poseStack.mulPose(Axis.XP.rotation(rootRotation.x()));
            poseStack.mulPose(Axis.YP.rotation(rootRotation.y()));
            poseStack.mulPose(Axis.ZP.rotation(rootRotation.z()));
            poseStack.translate(0.0, -0.5, 0.0);
        }
    }

    @Override
    public void renderDefaultPose(Fairy entity, FairyModel<Fairy> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-0.5, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.leftArmPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.rightArmPose = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.translate(0.5, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.leftArmPose = HumanoidModel.ArmPose.BLOCK;
                model.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.mulPose(Axis.YP.rotationDegrees(-35.0f));
                break;
            }
            default: {
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

