/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.renderer.EasyNPCRenderer;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LightLayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface EasyNPCModelRenderer<E extends EasyNPCBaseEntity<E>, M extends EntityModel<E>>
extends EasyNPCRenderer<E, M> {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static <T extends LivingEntity, M extends HumanoidModel<T>, L extends RenderLayer<T, M>, R extends LivingEntityRenderer<T, M>> L getHumanoidArmorLayer(R mobRenderer, EntityRendererProvider.Context context, ModelLayerLocation innerArmor, ModelLayerLocation outerArmor, Class<L> armorLayerClass) {
        if (armorLayerClass != null) {
            try {
                return (L)((RenderLayer)armorLayerClass.getConstructor(RenderLayerParent.class, HumanoidModel.class, HumanoidModel.class, ModelManager.class).newInstance(mobRenderer, new HumanoidModel(context.bakeLayer(innerArmor)), new HumanoidModel(context.bakeLayer(outerArmor)), context.getModelManager()));
            }
            catch (Exception e) {
                log.error("Failed to create custom armor layer for {} will use default armor layer instead.", mobRenderer, (Object)e);
            }
        }
        return (L)new HumanoidArmorLayer(mobRenderer, new HumanoidModel(context.bakeLayer(innerArmor)), new HumanoidModel(context.bakeLayer(outerArmor)), context.getModelManager());
    }

    public static void scaleEntity(EasyNPC<?> easyNPC, PoseStack poseStack) {
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        ScaleData scaleData = easyNPC.getEasyNPCScaleData();
        if (livingEntity.isBaby()) {
            poseStack.scale(scaleData.getScaleX().floatValue() * 0.5f, scaleData.getScaleY().floatValue() * 0.5f, scaleData.getScaleZ().floatValue() * 0.5f);
        } else {
            poseStack.scale(scaleData.getScaleX().floatValue() * 0.9375f, scaleData.getScaleY().floatValue() * 0.9375f, scaleData.getScaleZ().floatValue() * 0.9375f);
        }
    }

    public static void renderEntityNameTag(EasyNPC<?> easyNPC, PoseStack poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.translate(0.0f, -1.0f, 0.0f);
            poseStack.mulPose(Axis.XP.rotation(-rootRotation.x()));
            poseStack.mulPose(Axis.YP.rotation(-rootRotation.y()));
            poseStack.mulPose(Axis.ZP.rotation(-rootRotation.z()));
            poseStack.translate(0.0f, 1.0f, 0.0f);
        }
    }

    public static int getEntityLightLevel(EasyNPC<?> easyNPC, BlockPos blockPos) {
        int entityLightLevel = easyNPC.getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
        if (entityLightLevel > 0) {
            return entityLightLevel;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        return livingEntity.level().getBrightness(LightLayer.BLOCK, blockPos);
    }

    default public void renderCustomPose(E entity, M model, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
    }

    default public void renderDefaultPose(E entity, M model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
    }

    default public <N extends EasyNPC<E>> void rotateEntity(N easyNPC, PoseStack poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.translate(0.0f, 1.0f, 0.0f);
            poseStack.mulPose(Axis.XP.rotation(rootRotation.x()));
            poseStack.mulPose(Axis.YP.rotation(rootRotation.y()));
            poseStack.mulPose(Axis.ZP.rotation(rootRotation.z()));
            poseStack.translate(0.0f, -1.0f, 0.0f);
        }
    }

    default public void renderModel(E entity, M model, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.rotateEntity((EasyNPC)entity, poseStack);
        ModelPose modelPose = entity.getModelPose();
        if (modelPose == ModelPose.DEFAULT) {
            this.renderDefaultPose(entity, model, entity.getPose(), entityYaw, partialTicks, poseStack, buffer, packedLight);
        } else if (modelPose == ModelPose.CUSTOM) {
            this.renderCustomPose(entity, model, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }
}

