/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BasePlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class StandardPiglinModel<T extends LivingEntity>
extends BasePlayerModel<T> {
    private final ModelPart rightEar;
    private final ModelPart leftEar;

    public StandardPiglinModel(ModelPart modelPart) {
        super(modelPart);
        this.rightEar = this.defineModelPart(ModelPartType.RIGHT_EAR, this.head, "right_ear");
        this.leftEar = this.defineModelPart(ModelPartType.LEFT_EAR, this.head, "left_ear");
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float earSwing = ageInTicks * 0.1f + limbSwing * 0.5f;
        float earSwingAmount = 0.08f + limbSwingAmount * 0.4f;
        if (this.rightEar != null) {
            this.rightEar.zRot = 0.5235988f + Mth.cos((float)earSwing) * earSwingAmount;
        }
        if (this.leftEar != null) {
            this.leftEar.zRot = -0.5235988f - Mth.cos((float)(earSwing * 1.2f)) * earSwingAmount;
        }
    }
}

