/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseEntityModel;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantData;
import java.util.List;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class StandardHorseModel<T extends Entity>
extends BaseEntityModel<T>
implements HeadedModel {
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart tail;
    protected final ModelPart headParts;
    protected final ModelPart saddle;
    protected final ModelPart leftSaddleMouth;
    protected final ModelPart rightSaddleMouth;
    protected final ModelPart leftSaddleLine;
    protected final ModelPart rightSaddleLine;
    protected final ModelPart headSaddle;
    protected final ModelPart mouthSaddleWrap;

    public StandardHorseModel(ModelPart modelPart) {
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.headParts = this.defineModelPart(ModelPartType.HEAD_PARTS, modelPart, "head_parts");
        this.head = this.defineModelPart(ModelPartType.HEAD, this.headParts, "head");
        this.rightFrontLeg = this.defineModelPart(ModelPartType.RIGHT_FRONT_LEG, modelPart, "right_front_leg");
        this.leftFrontLeg = this.defineModelPart(ModelPartType.LEFT_FRONT_LEG, modelPart, "left_front_leg");
        this.rightHindLeg = this.defineModelPart(ModelPartType.RIGHT_HIND_LEG, modelPart, "right_hind_leg");
        this.leftHindLeg = this.defineModelPart(ModelPartType.LEFT_HIND_LEG, modelPart, "left_hind_leg");
        this.tail = this.defineModelPart(ModelPartType.TAIL, this.body, "tail");
        this.saddle = this.body.getChild("saddle");
        this.rightSaddleMouth = this.headParts.getChild("right_saddle_mouth");
        this.leftSaddleMouth = this.headParts.getChild("left_saddle_mouth");
        this.rightSaddleLine = this.headParts.getChild("right_saddle_line");
        this.leftSaddleLine = this.headParts.getChild("left_saddle_line");
        this.headSaddle = this.headParts.getChild("head_saddle");
        this.mouthSaddleWrap = this.headParts.getChild("mouth_saddle_wrap");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD_PARTS, this.headParts);
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg);
        this.resetModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg);
        this.resetModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg);
        this.resetModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
        this.resetModelPart(ModelPartType.TAIL, this.tail);
    }

    @Override
    public void adjustDefaultModelParts(T entity, EasyNPC<?> easyNPC) {
        boolean isSaddled;
        VariantData variantData = easyNPC.getEasyNPCVariantData();
        this.saddle.visible = isSaddled = variantData.hasVariantSaddled();
        this.rightSaddleMouth.visible = isSaddled;
        this.leftSaddleMouth.visible = isSaddled;
        this.rightSaddleLine.visible = isSaddled;
        this.leftSaddleLine.visible = isSaddled;
        this.headSaddle.visible = isSaddled;
        this.mouthSaddleWrap.visible = isSaddled;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.headParts, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftFrontLeg, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightFrontLeg, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftHindLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightHindLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelFrontLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    @Override
    public boolean animateModelHindLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        if (rightLegPart == null && leftLegPart == null) {
            return false;
        }
        if (rightLegPart != null) {
            rightLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (leftLegPart != null) {
            leftLegPart.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        return true;
    }

    public Iterable<ModelPart> headParts() {
        return List.of(this.headParts);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body, this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg);
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.headParts().forEach(headPart -> headPart.render(poseStack, vertexConsumer, light, overlay, color));
        this.bodyParts().forEach(bodyPart -> bodyPart.render(poseStack, vertexConsumer, light, overlay, color));
    }

    public ModelPart getHead() {
        return this.head;
    }

    @Override
    public boolean isHumanoidModel() {
        return false;
    }
}

