/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.custom;

import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.base.BaseHumanoidModel;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class FairyModel<T extends LivingEntity>
extends BaseHumanoidModel<T> {
    public static final float MODEL_OFFSET_Y = -1.0f;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public FairyModel(ModelPart modelPart) {
        super(modelPart);
        this.setDefaultModelPartVisibility(ModelPartType.LEFT_LEG, false);
        this.setDefaultModelPartVisibility(ModelPartType.HAT, false);
        this.leftWing = this.defineModelPart(ModelPartType.LEFT_WING, modelPart, "left_wing");
        this.rightWing = this.defineModelPart(ModelPartType.RIGHT_WING, modelPart, "right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)-1.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 25).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 41).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 15.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(56, 14).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-5.0f, (float)1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 14).mirror().addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(20, 57).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)5.0f, (float)1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(44, 55).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 41).addBox(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 0).addBox(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-1.9f, (float)11.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -8.0f, 0.0f, 20.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).addBox(-20.0f, -8.0f, 0.0f, 20.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.head, this.body, this.rightArm, this.leftArm, this.rightLeg, this.leftWing, this.rightWing);
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.HAT, this.hat);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.rightArm);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.leftArm);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.RIGHT_WING, this.rightWing);
        this.resetModelPart(ModelPartType.LEFT_WING, this.leftWing);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = 0.5f;
        this.body.y += 3.2f;
        this.body.z -= 1.2f;
        this.head.y += 4.2f;
        this.leftArm.xRot += 0.4f;
        this.leftArm.y += 5.2f;
        this.rightArm.xRot += 0.4f;
        this.rightArm.y += 5.2f;
        this.rightLeg.y += 4.0f;
        this.rightLeg.z = 4.4f;
        this.rightWing.y += 4.0f;
        this.leftWing.y += 4.0f;
        return true;
    }

    @Override
    public boolean additionalModelAnimation(T entity, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightWing.yRot = 0.47123894f + Mth.cos((float)(ageInTicks * 20.0f * ((float)Math.PI / 180))) * (float)Math.PI * 0.15f;
        this.leftWing.yRot = -this.rightWing.yRot;
        this.leftWing.zRot = -0.47123894f;
        this.leftWing.xRot = 0.47123894f;
        this.rightWing.xRot = 0.47123894f;
        this.rightWing.zRot = 0.47123894f;
        return true;
    }

    @Override
    public boolean setupStandingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupStandingModelPose(entity, modelData, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.rightLeg.xRot += 0.62831855f;
        return true;
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftArm, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightArm, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }
}

