/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.base;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidArmPoseAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidHeadAnimation;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class BaseHumanoidModel<E extends LivingEntity>
extends HumanoidModel<E>
implements EasyNPCModel<E>,
HumanoidArmAnimation,
HumanoidArmPoseAnimation,
HumanoidHeadAnimation,
HumanoidLegAnimation {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);

    public BaseHumanoidModel(ModelPart modelPart) {
        super(modelPart);
        this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.defineModelPart(ModelPartType.HAT, modelPart, "hat");
        this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.defineModelPart(ModelPartType.RIGHT_ARM, modelPart, "right_arm");
        this.defineModelPart(ModelPartType.LEFT_ARM, modelPart, "left_arm");
        this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
        this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.HAT, this.hat);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_ARM, this.rightArm);
        this.resetModelPart(ModelPartType.LEFT_ARM, this.leftArm);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public void adjustDefaultModelParts(E entity, EasyNPC<?> easyNPC) {
        if (this.hat.visible) {
            this.hat.copyFrom(this.head);
        }
    }

    @Override
    public void setupCustomModelPose(E entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.leftArm, modelData.getModelLeftArmPosition(), modelData.getModelLeftArmRotation(), modelData.isModelLeftArmVisible());
        ModelHelper.setPositionRotationVisibility(this.rightArm, modelData.getModelRightArmPosition(), modelData.getModelRightArmRotation(), modelData.isModelRightArmVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelHead(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidHeadAnimation.animateHumanoidModelHead(headPart, netHeadYaw, headPitch);
    }

    @Override
    public boolean animateModelArms(E entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidArmAnimation.animateHumanoidModelArms(rightArmPart, leftArmPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean animateModelArmPose(E entity, ModelArmPose modelArmPose, AttackData<?> attackData, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        return HumanoidArmPoseAnimation.animateHumanoidArmPose((Mob)entity, modelArmPose, this.head, this.body, this.rightArm, this.leftArm, this.attackTime, ageInTicks);
    }

    @Override
    public boolean setupCrouchingModelPose(E entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = 0.5f;
        this.body.y = 3.2f;
        this.head.y = 4.2f;
        this.leftArm.xRot += 0.4f;
        this.leftArm.y = 5.2f;
        this.leftLeg.y = 12.2f;
        this.leftLeg.z = 4.0f;
        this.rightArm.xRot += 0.4f;
        this.rightArm.y = 5.2f;
        this.rightLeg.y = 12.2f;
        this.rightLeg.z = 4.0f;
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, ModelPart> getModelPartMap() {
        return this.modelPartMap;
    }
}

