/*
 * Decompiled with CFR 0.152.
 */
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class MechanicraftLauncher {
    public static void main(String[] args) {
        FlatIntelliJLaf.setup();
        String appData = System.getenv("APPDATA");
        File mcDir = new File(appData, ".mechanicraft");
        boolean autoLaunch = false;
        for (String arg : args) {
            if (!arg.equals("--launch-minecraft")) continue;
            autoLaunch = true;
        }
        if (autoLaunch) {
            MechanicraftLauncher.runAutoUpdateAndLaunch(mcDir);
        } else if (!mcDir.exists()) {
            SwingUtilities.invokeLater(() -> MechanicraftLauncher.showFirstInstallUI(mcDir));
        } else {
            SwingUtilities.invokeLater(() -> MechanicraftLauncher.showAutoUpdateUI(mcDir));
        }
    }

    private static void showFirstInstallUI(File mcDir) {
        final JFrame frame = new JFrame("Mechanicraft - Premi\u00e8re installation");
        frame.setDefaultCloseOperation(3);
        frame.setMinimumSize(new Dimension(700, 600));
        frame.setSize(900, 700);
        frame.setLocationRelativeTo(null);
        try {
            frame.setIconImage(new ImageIcon(new URL("https://updater.mechanicraft.fluff.games/icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Color bgColor = Color.decode("#290a32");
        Font winFont = new Font("Segoe UI", 0, 16);
        JPanel panel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return frame.getSize();
            }
        };
        panel.setBackground(bgColor);
        panel.setLayout(new BoxLayout(panel, 1));
        final JLabel bannerLabel = new JLabel();
        bannerLabel.setAlignmentX(0.5f);
        bannerLabel.setBorder(BorderFactory.createEmptyBorder(32, 0, 16, 0));
        try {
            BufferedImage bannerImg = ImageIO.read(new URL("https://updater.mechanicraft.fluff.games/banner.png"));
            int maxW = 700;
            int maxH = 180;
            double ratio = Math.min((double)maxW / (double)bannerImg.getWidth(), (double)maxH / (double)bannerImg.getHeight());
            int w = (int)((double)bannerImg.getWidth() * ratio);
            int h = (int)((double)bannerImg.getHeight() * ratio);
            Image scaled = MechanicraftLauncher.getScaledImage(bannerImg, w, h);
            bannerLabel.setIcon(new ImageIcon(scaled));
        }
        catch (Exception bannerImg) {
            // empty catch block
        }
        panel.add(bannerLabel);
        JLabel welcome = new JLabel("<html><div style='text-align:center;'><span style='color:#ffffff; font-size:16px; font-family:Segoe UI;'>Ce launcher va installer et configurer automatiquement votre modpack.<br>Besoin d\u2019aide\u202f? <a href='https://discord.com/invite/wmhCWpjMr2' style='color:#7289da;'>Rejoignez notre Discord</a>.<br>Cliquez sur <b>Installer</b> pour commencer.</span></div></html>", 0);
        welcome.setForeground(Color.WHITE);
        welcome.setFont(winFont.deriveFont(0, 16.0f));
        welcome.setCursor(Cursor.getPredefinedCursor(12));
        welcome.setAlignmentX(0.5f);
        welcome.setBorder(BorderFactory.createEmptyBorder(0, 0, 14, 0));
        welcome.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://discord.com/invite/wmhCWpjMr2"));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(frame, "Impossible d'ouvrir le lien Discord.");
                }
            }
        });
        panel.add(welcome);
        final RoundedPanel logPanel = new RoundedPanel(28);
        logPanel.setBackground(new Color(44, 47, 51));
        logPanel.setLayout(new BorderLayout());
        logPanel.setBorder(BorderFactory.createEmptyBorder(12, 16, 12, 16));
        JTextArea logArea = new JTextArea();
        logArea.setEditable(false);
        logArea.setLineWrap(true);
        logArea.setWrapStyleWord(true);
        logArea.setOpaque(false);
        logArea.setForeground(new Color(230, 230, 230));
        logArea.setFont(winFont.deriveFont(0, 15.0f));
        logArea.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(logArea);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        scrollPane.setVerticalScrollBarPolicy(20);
        logPanel.add((Component)scrollPane, "Center");
        logPanel.setAlignmentX(0.5f);
        logPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 220));
        panel.add(logPanel);
        JPanel progressPanel = new JPanel();
        progressPanel.setBackground(bgColor);
        progressPanel.setLayout(new BoxLayout(progressPanel, 1));
        progressPanel.setBorder(BorderFactory.createEmptyBorder(18, 0, 10, 0));
        RoundProgressBar progressBar = new RoundProgressBar();
        progressBar.setPreferredSize(new Dimension(480, 36));
        progressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        progressBar.setBackground(new Color(44, 47, 51));
        progressBar.setForeground(new Color(245, 197, 66));
        progressBar.setFont(winFont.deriveFont(1, 15.0f));
        progressBar.setAlignmentX(0.5f);
        final JLabel progressLabel = new JLabel("Pr\u00eat \u00e0 installer...", 0);
        progressLabel.setForeground(Color.WHITE);
        progressLabel.setFont(winFont.deriveFont(0, 15.0f));
        progressLabel.setAlignmentX(0.5f);
        progressPanel.add(progressLabel);
        progressPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        final JPanel progressBarContainer = new JPanel();
        progressBarContainer.setOpaque(false);
        progressBarContainer.setLayout(new BoxLayout(progressBarContainer, 0));
        progressBarContainer.setBorder(BorderFactory.createEmptyBorder(0, 64, 0, 64));
        progressBarContainer.add(progressBar);
        progressPanel.add(progressBarContainer);
        panel.add(progressPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(bgColor);
        JButton installButton = new JButton("Installer");
        installButton.setFont(winFont.deriveFont(1, 15.0f));
        installButton.setBackground(new Color(245, 197, 66));
        installButton.setForeground(new Color(32, 34, 37));
        installButton.setFocusPainted(false);
        installButton.setBorder(BorderFactory.createEmptyBorder(8, 32, 8, 32));
        final JButton closeButton = new JButton("Fermer");
        closeButton.setFont(winFont.deriveFont(1, 15.0f));
        closeButton.setBackground(new Color(60, 60, 60));
        closeButton.setForeground(Color.WHITE);
        closeButton.setVisible(false);
        closeButton.setBorder(BorderFactory.createEmptyBorder(8, 32, 8, 32));
        buttonPanel.add(installButton);
        buttonPanel.add(closeButton);
        buttonPanel.setAlignmentX(0.5f);
        panel.add(buttonPanel);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int frameWidth = frame.getWidth();
                int maxW = Math.min(700, frameWidth - 40);
                int maxH = 180;
                try {
                    BufferedImage bannerImg = ImageIO.read(new URL("https://updater.mechanicraft.fluff.games/banner.png"));
                    double ratio = Math.min((double)maxW / (double)bannerImg.getWidth(), (double)maxH / (double)bannerImg.getHeight());
                    int w = (int)((double)bannerImg.getWidth() * ratio);
                    int h = (int)((double)bannerImg.getHeight() * ratio);
                    Image scaled = MechanicraftLauncher.getScaledImage(bannerImg, w, h);
                    bannerLabel.setIcon(new ImageIcon(scaled));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logPanel.setMaximumSize(new Dimension(frameWidth - 40, 220));
                progressBarContainer.setBorder(BorderFactory.createEmptyBorder(0, frameWidth / 8, 0, frameWidth / 8));
            }
        });
        frame.setContentPane(panel);
        frame.setVisible(true);
        installButton.addActionListener(e -> {
            installButton.setEnabled(false);
            logArea.setText("");
            progressLabel.setText("Installation en cours...");
            InstallWorker worker = new InstallWorker(mcDir, true, logArea, progressBar, progressLabel){

                @Override
                protected void done() {
                    super.done();
                    progressLabel.setText("Installation termin\u00e9e !");
                    closeButton.setVisible(true);
                }
            };
            worker.execute();
        });
        closeButton.addActionListener(e -> frame.dispose());
    }

    private static void showAutoUpdateUI(File mcDir) {
        JFrame frame = new JFrame("Mechanicraft");
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 120);
        frame.setLocationRelativeTo(null);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        JLabel statusLabel = new JLabel("V\u00e9rification de la version...", 0);
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setStringPainted(true);
        panel.add((Component)statusLabel, "Center");
        panel.add((Component)progressBar, "South");
        frame.setContentPane(panel);
        frame.setVisible(true);
        new InstallWorker(mcDir, false, null, progressBar, statusLabel).execute();
    }

    private static void runAutoUpdateAndLaunch(File mcDir) {
        try {
            if (!mcDir.exists()) {
                mcDir.mkdirs();
            }
            File manifestLocal = new File(mcDir, "manifest.json");
            String baseUrl = "https://updater.mechanicraft.fluff.games/";
            String manifestUrl = baseUrl + "manifest.json";
            String modpackUrl = baseUrl + "modpack.zip";
            File manifestTemp = new File(mcDir, "manifest_remote.json");
            boolean manifestOk = MechanicraftLauncher.downloadFile(manifestUrl, manifestTemp, null);
            if (!manifestOk || !manifestTemp.exists()) {
                throw new IOException("Le t\u00e9l\u00e9chargement du manifest a \u00e9chou\u00e9 (" + manifestTemp.getAbsolutePath() + ")");
            }
            if (!MechanicraftLauncher.isValidJson(manifestTemp)) {
                throw new IOException("Le manifest t\u00e9l\u00e9charg\u00e9 n'est pas un JSON valide !");
            }
            File modpackZip = new File(mcDir, "modpack.zip");
            MechanicraftLauncher.downloadFile(modpackUrl, modpackZip, null);
            File tempExtractDir = new File(mcDir, "temp_modpack");
            if (tempExtractDir.exists()) {
                MechanicraftLauncher.deleteDirectory(tempExtractDir);
            }
            tempExtractDir.mkdirs();
            MechanicraftLauncher.unzip(modpackZip, tempExtractDir);
            boolean modsIdentiques = MechanicraftLauncher.compareFolders(new File(mcDir, "mods"), new File(tempExtractDir, "mods"));
            boolean configIdentiques = MechanicraftLauncher.compareFolders(new File(mcDir, "config"), new File(tempExtractDir, "config"));
            if (!modsIdentiques) {
                MechanicraftLauncher.deleteDirectory(new File(mcDir, "mods"));
                MechanicraftLauncher.copyDirectory(new File(tempExtractDir, "mods"), new File(mcDir, "mods"));
            }
            if (!configIdentiques) {
                MechanicraftLauncher.deleteDirectory(new File(mcDir, "config"));
                MechanicraftLauncher.copyDirectory(new File(tempExtractDir, "config"), new File(mcDir, "config"));
            }
            MechanicraftLauncher.deleteDirectory(tempExtractDir);
            modpackZip.delete();
            if (!manifestTemp.exists()) {
                throw new IOException("Impossible de trouver le manifest t\u00e9l\u00e9charg\u00e9 juste avant la copie (" + manifestTemp.getAbsolutePath() + ")");
            }
            Files.copy(manifestTemp.toPath(), manifestLocal.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (manifestTemp.exists()) {
                manifestTemp.delete();
            }
            MechanicraftLauncher.checkAndInstallNeoForge(null);
            File iconFile = new File(mcDir, "icon.png");
            String iconUrl = "https://updater.mechanicraft.fluff.games/icon.png";
            if (!iconFile.exists()) {
                MechanicraftLauncher.downloadFile(iconUrl, iconFile, null);
            }
            MechanicraftLauncher.createOrUpdateProfile(mcDir);
            MechanicraftLauncher.launchMinecraft();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void launchMinecraft() throws IOException {
        String appData = System.getenv("APPDATA");
        File launcherExe = new File(appData, ".minecraft\\launcher\\launcher.exe");
        if (!launcherExe.exists()) {
            launcherExe = new File(appData, ".minecraft\\launcher.exe");
        }
        if (!launcherExe.exists()) {
            System.err.println("Impossible de trouver le launcher Minecraft !");
            return;
        }
        new ProcessBuilder(launcherExe.getAbsolutePath()).start();
    }

    private static boolean downloadFile(String urlString, File destination, JTextArea logArea) {
        boolean bl;
        block10: {
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            try {
                Files.copy(in, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (destination.exists()) {
                        destination.delete();
                    }
                    if (logArea != null) {
                        logArea.append("Erreur lors du t\u00e9l\u00e9chargement de " + urlString + " : " + e.getMessage() + "\n");
                    }
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private static void unzip(File zipFile, File destDir) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    newFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private static boolean compareFolders(File dir1, File dir2) {
        if (!dir1.exists() && !dir2.exists()) {
            return true;
        }
        if (!dir1.exists() || !dir2.exists()) {
            return false;
        }
        File[] files1 = dir1.listFiles();
        File[] files2 = dir2.listFiles();
        if (files1 == null || files2 == null) {
            return false;
        }
        if (files1.length != files2.length) {
            return false;
        }
        for (File f1 : files1) {
            File f2 = new File(dir2, f1.getName());
            if (!f2.exists()) {
                return false;
            }
            if (!(f1.isDirectory() ? !MechanicraftLauncher.compareFolders(f1, f2) : f1.length() != f2.length())) continue;
            return false;
        }
        return true;
    }

    private static void deleteDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    MechanicraftLauncher.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        dir.delete();
    }

    private static void copyDirectory(File src, File dest) throws IOException {
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            String[] children;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            if ((children = src.list()) != null) {
                for (String child : children) {
                    MechanicraftLauncher.copyDirectory(new File(src, child), new File(dest, child));
                }
            }
        } else {
            Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static String encodeIconToBase64(File iconFile) throws IOException {
        byte[] bytes = Files.readAllBytes(iconFile.toPath());
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static void createOrUpdateProfile(File mcDir) throws IOException {
        JsonObject root;
        String appData = System.getenv("APPDATA");
        File launcherProfiles = new File(appData, ".minecraft/launcher_profiles.json");
        if (!launcherProfiles.exists()) {
            throw new IOException("Impossible de trouver launcher_profiles.json ! Lance Minecraft une premi\u00e8re fois.");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileReader reader = new FileReader(launcherProfiles);){
            root = gson.fromJson((Reader)reader, JsonObject.class);
        }
        JsonObject profiles = root.has("profiles") ? root.getAsJsonObject("profiles") : new JsonObject();
        String iconBase64 = MechanicraftLauncher.encodeIconToBase64(new File(mcDir, "icon.png"));
        JsonObject mechanicraftProfile = new JsonObject();
        mechanicraftProfile.addProperty("name", "Mechanicraft");
        mechanicraftProfile.addProperty("gameDir", mcDir.getAbsolutePath());
        mechanicraftProfile.addProperty("lastVersionId", "neoforge-21.1.173");
        mechanicraftProfile.addProperty("icon", "data:image/png;base64," + iconBase64);
        mechanicraftProfile.addProperty("javaArgs", "-Xmx8G");
        profiles.add("Mechanicraft", mechanicraftProfile);
        root.add("profiles", profiles);
        try (FileWriter writer = new FileWriter(launcherProfiles);){
            gson.toJson((JsonElement)root, (Appendable)writer);
        }
    }

    private static void checkAndInstallNeoForge(JProgressBar progressBar) {
        block7: {
            try {
                String appData = System.getenv("APPDATA");
                String versionFolder = "neoforge-21.1.173";
                File versionsDir = new File(appData, ".minecraft/versions/" + versionFolder);
                if (versionsDir.exists()) {
                    if (progressBar != null) {
                        progressBar.setValue(90);
                    }
                    return;
                }
                String neoforgeZipUrl = "https://updater.mechanicraft.fluff.games/versions/neoforge-21.1.173.zip";
                File neoforgeZip = new File(appData, ".minecraft/versions/neoforge-21.1.173.zip");
                if (progressBar != null) {
                    progressBar.setValue(87);
                }
                MechanicraftLauncher.downloadFile(neoforgeZipUrl, neoforgeZip, null);
                File versionsTarget = new File(appData, ".minecraft/versions");
                if (progressBar != null) {
                    progressBar.setValue(89);
                }
                MechanicraftLauncher.unzip(neoforgeZip, versionsTarget);
                neoforgeZip.delete();
                if (progressBar != null) {
                    progressBar.setValue(90);
                }
            }
            catch (Exception e) {
                if (progressBar == null) break block7;
                progressBar.setValue(0);
            }
        }
    }

    private static boolean isValidJson(File file) {
        boolean bl;
        FileReader reader = new FileReader(file);
        try {
            new Gson().fromJson((Reader)reader, Object.class);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        ((Reader)reader).close();
        return bl;
    }

    public static Image getScaledImage(BufferedImage srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 2);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    static class RoundedPanel
    extends JPanel {
        private final int radius;

        RoundedPanel(int radius) {
            this.radius = radius;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getBackground());
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.radius, this.radius);
            g2.dispose();
            super.paintComponent(g);
        }
    }

    static class RoundProgressBar
    extends JProgressBar {
        public RoundProgressBar() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int arc = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getBackground());
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
            g2.setColor(this.getForeground());
            int w = (int)((double)this.getWidth() * this.getPercentComplete());
            if (w > 0) {
                g2.fillRoundRect(0, 0, w, this.getHeight(), arc, arc);
                if (w < arc) {
                    g2.fillArc(0, 0, arc, arc, 90, 180);
                }
                if (w > this.getWidth() - arc) {
                    g2.fillArc(this.getWidth() - arc, 0, arc, arc, 270, 180);
                }
            }
            g2.dispose();
            super.paintComponent(g);
        }
    }

    static class InstallWorker
    extends SwingWorker<Void, String> {
        private final File mcDir;
        private final boolean isFirstInstall;
        private final JTextArea logArea;
        private final JProgressBar progressBar;
        private final JLabel statusLabel;

        InstallWorker(File mcDir, boolean isFirstInstall, JTextArea logArea, JProgressBar progressBar, JLabel statusLabel) {
            this.mcDir = mcDir;
            this.isFirstInstall = isFirstInstall;
            this.logArea = logArea;
            this.progressBar = progressBar;
            this.statusLabel = statusLabel;
        }

        @Override
        protected Void doInBackground() {
            try {
                this.updateProgress(0);
                this.log("Pr\u00e9paration du dossier...");
                if (!this.mcDir.exists()) {
                    this.mcDir.mkdirs();
                }
                File manifestLocal = new File(this.mcDir, "manifest.json");
                String baseUrl = "https://updater.mechanicraft.fluff.games/";
                String manifestUrl = baseUrl + "manifest.json";
                String modpackUrl = baseUrl + "modpack.zip";
                this.updateProgress(10);
                this.log("T\u00e9l\u00e9chargement du manifest...");
                File manifestTemp = new File(this.mcDir, "manifest_remote.json");
                boolean manifestOk = MechanicraftLauncher.downloadFile(manifestUrl, manifestTemp, this.logArea);
                this.log("Apr\u00e8s t\u00e9l\u00e9chargement, manifestTemp.exists() = " + manifestTemp.exists());
                if (!manifestOk || !manifestTemp.exists()) {
                    throw new IOException("Le t\u00e9l\u00e9chargement du manifest a \u00e9chou\u00e9 (" + manifestTemp.getAbsolutePath() + ")");
                }
                if (!MechanicraftLauncher.isValidJson(manifestTemp)) {
                    throw new IOException("Le manifest t\u00e9l\u00e9charg\u00e9 n'est pas un JSON valide !");
                }
                this.updateProgress(30);
                this.log("T\u00e9l\u00e9chargement du modpack...");
                File modpackZip = new File(this.mcDir, "modpack.zip");
                MechanicraftLauncher.downloadFile(modpackUrl, modpackZip, this.logArea);
                this.updateProgress(45);
                this.log("Extraction du modpack...");
                File tempExtractDir = new File(this.mcDir, "temp_modpack");
                if (tempExtractDir.exists()) {
                    MechanicraftLauncher.deleteDirectory(tempExtractDir);
                }
                tempExtractDir.mkdirs();
                MechanicraftLauncher.unzip(modpackZip, tempExtractDir);
                this.updateProgress(60);
                if (this.isFirstInstall) {
                    this.log("Premi\u00e8re installation\u202f: copie de tous les dossiers du modpack...");
                    File[] tempExtractFiles = tempExtractDir.listFiles();
                    if (tempExtractFiles != null) {
                        for (File file : tempExtractFiles) {
                            MechanicraftLauncher.copyDirectory(file, new File(this.mcDir, file.getName()));
                        }
                    }
                } else {
                    this.log("Mise \u00e0 jour des dossiers mods/config...");
                    boolean modsIdentiques = MechanicraftLauncher.compareFolders(new File(this.mcDir, "mods"), new File(tempExtractDir, "mods"));
                    boolean configIdentiques = MechanicraftLauncher.compareFolders(new File(this.mcDir, "config"), new File(tempExtractDir, "config"));
                    if (!modsIdentiques) {
                        MechanicraftLauncher.deleteDirectory(new File(this.mcDir, "mods"));
                        MechanicraftLauncher.copyDirectory(new File(tempExtractDir, "mods"), new File(this.mcDir, "mods"));
                    }
                    if (!configIdentiques) {
                        MechanicraftLauncher.deleteDirectory(new File(this.mcDir, "config"));
                        MechanicraftLauncher.copyDirectory(new File(tempExtractDir, "config"), new File(this.mcDir, "config"));
                    }
                }
                MechanicraftLauncher.deleteDirectory(tempExtractDir);
                modpackZip.delete();
                this.updateProgress(75);
                this.log("Mise \u00e0 jour du manifest local...");
                if (!manifestTemp.exists()) {
                    throw new IOException("Impossible de trouver le manifest t\u00e9l\u00e9charg\u00e9 juste avant la copie (" + manifestTemp.getAbsolutePath() + ")");
                }
                Files.copy(manifestTemp.toPath(), manifestLocal.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (manifestTemp.exists()) {
                    manifestTemp.delete();
                }
                this.updateProgress(85);
                this.log("V\u00e9rification de NeoForge...");
                MechanicraftLauncher.checkAndInstallNeoForge(this.progressBar);
                this.updateProgress(90);
                this.log("V\u00e9rification de l'ic\u00f4ne...");
                File iconFile = new File(this.mcDir, "icon.png");
                String iconUrl = "https://updater.mechanicraft.fluff.games/icon.png";
                if (!iconFile.exists()) {
                    MechanicraftLauncher.downloadFile(iconUrl, iconFile, this.logArea);
                }
                this.updateProgress(95);
                this.log("Mise \u00e0 jour du profil Minecraft...");
                MechanicraftLauncher.createOrUpdateProfile(this.mcDir);
                this.updateProgress(100);
            }
            catch (Exception e) {
                this.updateProgress(0);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.log("Erreur : " + sw.toString());
            }
            return null;
        }

        @Override
        protected void process(List<String> chunks) {
            if (this.isFirstInstall && this.logArea != null) {
                for (String msg : chunks) {
                    this.logArea.append(msg + "\n");
                    this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
                }
            }
        }

        @Override
        protected void done() {
            this.updateProgress(100);
            if (this.isFirstInstall && this.logArea != null) {
                this.logArea.append("Mechanicraft install\u00e9 et pr\u00eat \u00e0 \u00eatre lanc\u00e9\n");
            }
            if (!this.isFirstInstall && this.statusLabel != null) {
                this.statusLabel.setText("Jeu \u00e0 jour !");
            }
        }

        private void log(String msg) {
            if (this.isFirstInstall && this.logArea != null) {
                this.publish(msg);
            }
        }

        private void updateProgress(int value) {
            if (this.progressBar != null) {
                SwingUtilities.invokeLater(() -> this.progressBar.setValue(value));
            }
        }
    }
}

